/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.HttpHandlerAdapterSupport;
import org.springframework.http.server.reactive.ReactorServerHttpRequest;
import org.springframework.http.server.reactive.ReactorServerHttpResponse;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;

public class ReactorHttpHandlerAdapter
extends HttpHandlerAdapterSupport
implements BiFunction<HttpServerRequest, HttpServerResponse, Mono<Void>> {
    public ReactorHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    public ReactorHttpHandlerAdapter(Map<String, HttpHandler> handlerMap) {
        super(handlerMap);
    }

    @Override
    public Mono<Void> apply(HttpServerRequest request, HttpServerResponse response) {
        NettyDataBufferFactory bufferFactory = new NettyDataBufferFactory(response.alloc());
        ReactorServerHttpRequest req = new ReactorServerHttpRequest(request, bufferFactory);
        ReactorServerHttpResponse resp = new ReactorServerHttpResponse(response, (DataBufferFactory)bufferFactory);
        return this.getHttpHandler().handle(req, resp).otherwise(ex -> {
            this.logger.error((Object)"Could not complete request", ex);
            response.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return Mono.empty();
        }).doOnSuccess(aVoid -> this.logger.debug((Object)"Successfully completed request"));
    }
}

