/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.cookie.Cookie;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import rx.Observable;
import rx.RxReactiveStreams;

public class RxNettyServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServerRequest<ByteBuf> request;
    private final NettyDataBufferFactory dataBufferFactory;
    private final InetSocketAddress remoteAddress;

    public RxNettyServerHttpRequest(HttpServerRequest<ByteBuf> request, NettyDataBufferFactory dataBufferFactory, InetSocketAddress remoteAddress) {
        super(RxNettyServerHttpRequest.initUri(request, remoteAddress), RxNettyServerHttpRequest.initHeaders(request));
        Assert.notNull((Object)dataBufferFactory, (String)"'dataBufferFactory' must not be null");
        this.request = request;
        this.dataBufferFactory = dataBufferFactory;
        this.remoteAddress = remoteAddress;
    }

    private static URI initUri(HttpServerRequest<ByteBuf> request, InetSocketAddress remoteAddress) {
        Assert.notNull(request, (String)"'request' must not be null");
        String requestUri = request.getUri();
        return remoteAddress != null ? RxNettyServerHttpRequest.getBaseUrl(remoteAddress).resolve(requestUri) : URI.create(requestUri);
    }

    private static URI getBaseUrl(InetSocketAddress address) {
        try {
            return new URI(null, null, address.getHostString(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static HttpHeaders initHeaders(HttpServerRequest<ByteBuf> request) {
        HttpHeaders headers = new HttpHeaders();
        for (String name : request.getHeaderNames()) {
            headers.put(name, request.getAllHeaderValues((CharSequence)name));
        }
        return headers;
    }

    public HttpServerRequest<ByteBuf> getRxNettyRequest() {
        return this.request;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.request.getHttpMethod().name());
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (String name : this.request.getCookies().keySet()) {
            for (Cookie cookie : (Set)this.request.getCookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name, cookie.value());
                cookies.add((Object)name, (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    public Optional<InetSocketAddress> getRemoteAddress() {
        return Optional.ofNullable(this.remoteAddress);
    }

    @Override
    public Flux<DataBuffer> getBody() {
        Observable content = this.request.getContent().map(arg_0 -> ((NettyDataBufferFactory)this.dataBufferFactory).wrap(arg_0));
        return Flux.from((Publisher)RxReactiveStreams.toPublisher((Observable)content));
    }
}

