/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.web.util.patterns.PathElement;
import org.springframework.web.util.patterns.PathPattern;
import org.springframework.web.util.patterns.PatternMessage;
import org.springframework.web.util.patterns.PatternParseException;
import org.springframework.web.util.patterns.SubSequence;

class RegexPathElement
extends PathElement {
    private final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
    private final String DEFAULT_VARIABLE_PATTERN = "(.*)";
    private final List<String> variableNames = new LinkedList<String>();
    private char[] regex;
    private Pattern pattern;
    private boolean caseSensitive;
    private int wildcardCount;

    RegexPathElement(int pos, char[] regex, boolean caseSensitive, char[] completePattern) {
        super(pos);
        this.regex = regex;
        this.caseSensitive = caseSensitive;
        this.buildPattern(regex, completePattern);
    }

    public void buildPattern(char[] regex, char[] completePattern) {
        StringBuilder patternBuilder = new StringBuilder();
        String text = new String(regex);
        Matcher matcher = this.GLOB_PATTERN.matcher(text);
        int end = 0;
        while (matcher.find()) {
            patternBuilder.append(this.quote(text, end, matcher.start()));
            String match = matcher.group();
            if ("?".equals(match)) {
                patternBuilder.append('.');
            } else if ("*".equals(match)) {
                patternBuilder.append(".*");
                ++this.wildcardCount;
            } else if (match.startsWith("{") && match.endsWith("}")) {
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    patternBuilder.append("(.*)");
                    String variableName = matcher.group(1);
                    if (this.variableNames.contains(variableName)) {
                        throw new PatternParseException(this.pos, completePattern, PatternMessage.ILLEGAL_DOUBLE_CAPTURE, variableName);
                    }
                    this.variableNames.add(variableName);
                } else {
                    String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                    patternBuilder.append('(');
                    patternBuilder.append(variablePattern);
                    patternBuilder.append(')');
                    String variableName = match.substring(1, colonIdx);
                    if (this.variableNames.contains(variableName)) {
                        throw new PatternParseException(this.pos, completePattern, PatternMessage.ILLEGAL_DOUBLE_CAPTURE, variableName);
                    }
                    this.variableNames.add(variableName);
                }
            }
            end = matcher.end();
        }
        patternBuilder.append(this.quote(text, end, text.length()));
        this.pattern = this.caseSensitive ? Pattern.compile(patternBuilder.toString()) : Pattern.compile(patternBuilder.toString(), 2);
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    private String quote(String s, int start, int end) {
        if (start == end) {
            return "";
        }
        return Pattern.quote(s.substring(start, end));
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        int p = matchingContext.scanAhead(candidateIndex);
        Matcher m = this.pattern.matcher(new SubSequence(matchingContext.candidate, candidateIndex, p));
        boolean matches = m.matches();
        if (matches) {
            if (this.next == null) {
                matches = p == matchingContext.candidateLength && (this.variableNames.size() == 0 || p > candidateIndex);
            } else {
                if (matchingContext.isMatchStartMatching && p == matchingContext.candidateLength) {
                    return true;
                }
                matches = this.next.matches(p, matchingContext);
            }
        }
        if (matches && matchingContext.extractingVariables) {
            if (this.variableNames.size() != m.groupCount()) {
                throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
            }
            for (int i = 1; i <= m.groupCount(); ++i) {
                String name = this.variableNames.get(i - 1);
                String value = m.group(i);
                matchingContext.set(name, value);
            }
        }
        return matches;
    }

    public String toString() {
        return "Regex(" + new String(this.regex) + ")";
    }

    @Override
    public int getNormalizedLength() {
        int varsLength = 0;
        for (String variableName : this.variableNames) {
            varsLength += variableName.length();
        }
        return this.regex.length - varsLength - this.variableNames.size();
    }

    @Override
    public int getCaptureCount() {
        return this.variableNames.size();
    }

    @Override
    public int getWildcardCount() {
        return this.wildcardCount;
    }

    @Override
    public int getScore() {
        return this.getCaptureCount() * 1 + this.getWildcardCount() * 100;
    }
}

