/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorClientHttpRequest;
import org.springframework.http.client.reactive.ReactorClientHttpResponse;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;

public class ReactorClientHttpConnector
implements ClientHttpConnector {
    private static final Mono<ClientHttpResponse> NO_CLIENT_RESPONSE_ERROR = Mono.error((Throwable)new IllegalStateException("HttpClient completed without a response. As a temporary workaround try to disable connection pool. See https://github.com/reactor/reactor-netty/issues/138."));
    private final HttpClient httpClient;

    public ReactorClientHttpConnector() {
        this.httpClient = HttpClient.create();
    }

    public ReactorClientHttpConnector(Consumer<? super HttpClientOptions.Builder> clientOptions) {
        this.httpClient = HttpClient.create(clientOptions);
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        if (!uri.isAbsolute()) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is not absolute: " + uri));
        }
        return this.httpClient.request(this.adaptHttpMethod(method), uri.toString(), request -> (Mono)requestCallback.apply(this.adaptRequest(method, uri, (HttpClientRequest)request))).map(this::adaptResponse).switchIfEmpty(NO_CLIENT_RESPONSE_ERROR);
    }

    private io.netty.handler.codec.http.HttpMethod adaptHttpMethod(HttpMethod method) {
        return io.netty.handler.codec.http.HttpMethod.valueOf((String)method.name());
    }

    private ReactorClientHttpRequest adaptRequest(HttpMethod method, URI uri, HttpClientRequest request) {
        return new ReactorClientHttpRequest(method, uri, request);
    }

    private ClientHttpResponse adaptResponse(HttpClientResponse response) {
        return new ReactorClientHttpResponse(response);
    }
}

