/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.session;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.session.WebSessionIdResolver;

public class CookieWebSessionIdResolver
implements WebSessionIdResolver {
    private String cookieName = "SESSION";
    private Duration cookieMaxAge = Duration.ofSeconds(-1L);

    public void setCookieName(String cookieName) {
        Assert.hasText((String)cookieName, (String)"'cookieName' must not be empty.");
        this.cookieName = cookieName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieMaxAge(Duration maxAge) {
        this.cookieMaxAge = maxAge;
    }

    public Duration getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    @Override
    public List<String> resolveSessionIds(ServerWebExchange exchange) {
        MultiValueMap<String, HttpCookie> cookieMap = exchange.getRequest().getCookies();
        List cookies = (List)cookieMap.get((Object)this.getCookieName());
        if (cookies == null) {
            return Collections.emptyList();
        }
        return cookies.stream().map(HttpCookie::getValue).collect(Collectors.toList());
    }

    @Override
    public void setSessionId(ServerWebExchange exchange, String id) {
        Assert.notNull((Object)id, (String)"'id' is required");
        this.setSessionCookie(exchange, id, this.getCookieMaxAge());
    }

    @Override
    public void expireSession(ServerWebExchange exchange) {
        this.setSessionCookie(exchange, "", Duration.ofSeconds(0L));
    }

    private void setSessionCookie(ServerWebExchange exchange, String id, Duration maxAge) {
        String name = this.getCookieName();
        boolean secure = "https".equalsIgnoreCase(exchange.getRequest().getURI().getScheme());
        MultiValueMap<String, ResponseCookie> cookieMap = exchange.getResponse().getCookies();
        cookieMap.set((Object)name, (Object)ResponseCookie.from(name, id).maxAge(maxAge).httpOnly(true).secure(secure).build());
    }
}

