/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.http.server.reactive.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class ParsingPathMatcher
implements PathMatcher {
    private final PathPatternParser parser = new PathPatternParser();
    private final ConcurrentMap<String, PathPattern> cache = new ConcurrentHashMap<String, PathPattern>(256);

    public boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    public boolean match(String pattern, String path) {
        PathPattern pathPattern = this.getPathPattern(pattern);
        return pathPattern.matches(PathContainer.parseUrlPath(path));
    }

    public boolean matchStart(String pattern, String path) {
        PathPattern pathPattern = this.getPathPattern(pattern);
        return pathPattern.matchStart(PathContainer.parseUrlPath(path));
    }

    public String extractPathWithinPattern(String pattern, String path) {
        PathPattern pathPattern = this.getPathPattern(pattern);
        PathContainer pathContainer = PathContainer.parseUrlPath(path);
        return pathPattern.extractPathWithinPattern(pathContainer).value();
    }

    public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
        PathContainer pathContainer;
        PathPattern pathPattern = this.getPathPattern(pattern);
        PathPattern.PathMatchResult results = pathPattern.matchAndExtract(pathContainer = PathContainer.parseUrlPath(path));
        if (results.getUriVariables().size() == 0) {
            return Collections.emptyMap();
        }
        return results.getUriVariables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Comparator<String> getPatternComparator(String path) {
        return new PathPatternStringComparatorConsideringPath(path);
    }

    public String combine(String pattern1, String pattern2) {
        PathPattern pathPattern = this.getPathPattern(pattern1);
        return pathPattern.combine(this.getPathPattern(pattern2)).getPatternString();
    }

    private PathPattern getPathPattern(String pattern) {
        PathPattern pathPattern = (PathPattern)this.cache.get(pattern);
        if (pathPattern == null) {
            pathPattern = this.parser.parse(pattern);
            this.cache.put(pattern, pathPattern);
        }
        return pathPattern;
    }

    static class PatternComparatorConsideringPath
    implements Comparator<PathPattern> {
        private final String path;

        public PatternComparatorConsideringPath(String path) {
            this.path = path;
        }

        @Override
        public int compare(@Nullable PathPattern o1, @Nullable PathPattern o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.getPatternString().equals(this.path)) {
                return o2.getPatternString().equals(this.path) ? 0 : -1;
            }
            if (o2.getPatternString().equals(this.path)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    private class PathPatternStringComparatorConsideringPath
    implements Comparator<String> {
        private final PatternComparatorConsideringPath ppcp;

        public PathPatternStringComparatorConsideringPath(String path) {
            this.ppcp = new PatternComparatorConsideringPath(path);
        }

        @Override
        public int compare(@Nullable String o1, @Nullable String o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            PathPattern p1 = ParsingPathMatcher.this.getPathPattern(o1);
            PathPattern p2 = ParsingPathMatcher.this.getPathPattern(o2);
            return this.ppcp.compare(p1, p2);
        }
    }
}

