/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.server.reactive.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.pattern.CaptureTheRestPathElement;
import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPatternParser;
import org.springframework.web.util.pattern.SeparatorPathElement;
import org.springframework.web.util.pattern.WildcardPathElement;
import org.springframework.web.util.pattern.WildcardTheRestPathElement;

public class PathPattern
implements Comparable<PathPattern> {
    private static final PathContainer EMPTY_PATH = PathContainer.parsePath("");
    private final PathPatternParser parser;
    @Nullable
    private final PathElement head;
    private String patternString;
    private char separator;
    private boolean caseSensitive;
    private boolean allowOptionalTrailingSlash;
    private int capturedVariableCount;
    private int normalizedLength;
    private boolean endsWithSeparatorWildcard = false;
    private int score;
    private boolean catchAll = false;

    PathPattern(String patternText, PathPatternParser parser, @Nullable PathElement head, char separator, boolean caseSensitive, boolean allowOptionalTrailingSlash) {
        this.patternString = patternText;
        this.parser = parser;
        this.head = head;
        this.separator = separator;
        this.caseSensitive = caseSensitive;
        this.allowOptionalTrailingSlash = allowOptionalTrailingSlash;
        PathElement elem = head;
        while (elem != null) {
            this.capturedVariableCount += elem.getCaptureCount();
            this.normalizedLength += elem.getNormalizedLength();
            this.score += elem.getScore();
            if (elem instanceof CaptureTheRestPathElement || elem instanceof WildcardTheRestPathElement) {
                this.catchAll = true;
            }
            if (elem instanceof SeparatorPathElement && elem.next != null && elem.next instanceof WildcardPathElement && elem.next.next == null) {
                this.endsWithSeparatorWildcard = true;
            }
            elem = elem.next;
        }
    }

    public String getPatternString() {
        return this.patternString;
    }

    public boolean matches(PathContainer pathContainer) {
        if (this.head == null) {
            return !this.hasLength(pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                pathContainer = EMPTY_PATH;
            } else {
                return false;
            }
        }
        MatchingContext matchingContext = new MatchingContext(pathContainer, false);
        return this.head.matches(0, matchingContext);
    }

    @Nullable
    public PathRemainingMatchInfo getPathRemaining(PathContainer pathContainer) {
        if (this.head == null) {
            return new PathRemainingMatchInfo(pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            return null;
        }
        MatchingContext matchingContext = new MatchingContext(pathContainer, true);
        matchingContext.setMatchAllowExtraPath();
        boolean matches = this.head.matches(0, matchingContext);
        if (!matches) {
            return null;
        }
        PathRemainingMatchInfo info = matchingContext.remainingPathIndex == pathContainer.elements().size() ? new PathRemainingMatchInfo(EMPTY_PATH, matchingContext.getPathMatchResult()) : new PathRemainingMatchInfo(pathContainer.subPath(matchingContext.remainingPathIndex), matchingContext.getPathMatchResult());
        return info;
    }

    public boolean matchStart(PathContainer pathContainer) {
        if (this.head == null) {
            return !this.hasLength(pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            return true;
        }
        MatchingContext matchingContext = new MatchingContext(pathContainer, false);
        matchingContext.setMatchStartMatching(true);
        return this.head.matches(0, matchingContext);
    }

    public PathMatchResult matchAndExtract(PathContainer pathContainer) {
        MatchingContext matchingContext = new MatchingContext(pathContainer, true);
        if (this.head != null && this.head.matches(0, matchingContext)) {
            return matchingContext.getPathMatchResult();
        }
        if (!this.hasLength(pathContainer)) {
            return PathMatchResult.EMPTY;
        }
        throw new IllegalStateException("Pattern \"" + this + "\" is not a match for \"" + pathContainer.value() + "\"");
    }

    public PathContainer extractPathWithinPattern(PathContainer path) {
        String result = this.extractPathWithinPattern(path.value());
        return PathContainer.parseUrlPath(result);
    }

    private String extractPathWithinPattern(String path) {
        int end;
        PathElement elem = this.head;
        int separatorCount = 0;
        boolean matchTheRest = false;
        while (elem != null) {
            if (elem instanceof SeparatorPathElement || elem instanceof CaptureTheRestPathElement || elem instanceof WildcardTheRestPathElement) {
                ++separatorCount;
                if (elem instanceof WildcardTheRestPathElement || elem instanceof CaptureTheRestPathElement) {
                    matchTheRest = true;
                }
            }
            if (elem.getWildcardCount() != 0 || elem.getCaptureCount() != 0) break;
            elem = elem.next;
        }
        if (elem == null) {
            return "";
        }
        char[] pathChars = path.toCharArray();
        int len = pathChars.length;
        int pos = 0;
        while (separatorCount > 0 && pos < len) {
            if (path.charAt(pos++) != this.separator) continue;
            --separatorCount;
        }
        if (!matchTheRest) {
            for (end = len; end > 0 && path.charAt(end - 1) == this.separator; --end) {
            }
        }
        StringBuilder stringWithDuplicateSeparatorsRemoved = null;
        for (int c = pos; c < end; ++c) {
            char ch = path.charAt(c);
            if (ch == this.separator && c + 1 < end && path.charAt(c + 1) == this.separator) {
                if (stringWithDuplicateSeparatorsRemoved == null) {
                    stringWithDuplicateSeparatorsRemoved = new StringBuilder();
                    stringWithDuplicateSeparatorsRemoved.append(path.substring(pos, c));
                }
                while (++c + 1 < end && path.charAt(c + 1) == this.separator) {
                }
            }
            if (stringWithDuplicateSeparatorsRemoved == null) continue;
            stringWithDuplicateSeparatorsRemoved.append(ch);
        }
        if (stringWithDuplicateSeparatorsRemoved != null) {
            return stringWithDuplicateSeparatorsRemoved.toString();
        }
        return pos == len ? "" : path.substring(pos, end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(@Nullable PathPattern otherPattern) {
        int score;
        if (otherPattern == null) {
            return -1;
        }
        if (this.isCatchAll()) {
            if (!otherPattern.isCatchAll()) return 1;
            int lenDifference = this.getNormalizedLength() - otherPattern.getNormalizedLength();
            if (lenDifference != 0) {
                if (lenDifference >= 0) return -1;
                return 1;
            }
        } else if (otherPattern.isCatchAll()) {
            return -1;
        }
        if ((score = this.getScore() - otherPattern.getScore()) != 0) {
            if (score >= 0) return 1;
            return -1;
        }
        int lenDifference = this.getNormalizedLength() - otherPattern.getNormalizedLength();
        if (lenDifference < 0) {
            return 1;
        }
        if (lenDifference != 0) return -1;
        return 0;
    }

    public PathPattern combine(PathPattern pattern2string) {
        boolean secondExtensionWild;
        if (!StringUtils.hasLength((String)this.patternString)) {
            if (!StringUtils.hasLength((String)pattern2string.patternString)) {
                return this.parser.parse("");
            }
            return pattern2string;
        }
        if (!StringUtils.hasLength((String)pattern2string.patternString)) {
            return this;
        }
        if (!this.patternString.equals(pattern2string.patternString) && this.capturedVariableCount == 0 && this.matches(PathContainer.parseUrlPath(pattern2string.patternString))) {
            return pattern2string;
        }
        if (this.endsWithSeparatorWildcard) {
            return this.parser.parse(this.concat(this.patternString.substring(0, this.patternString.length() - 2), pattern2string.patternString));
        }
        int starDotPos1 = this.patternString.indexOf("*.");
        if (this.capturedVariableCount != 0 || starDotPos1 == -1 || this.separator == '.') {
            return this.parser.parse(this.concat(this.patternString, pattern2string.patternString));
        }
        String firstExtension = this.patternString.substring(starDotPos1 + 1);
        String p2string = pattern2string.patternString;
        int dotPos2 = p2string.indexOf(46);
        String file2 = dotPos2 == -1 ? p2string : p2string.substring(0, dotPos2);
        String secondExtension = dotPos2 == -1 ? "" : p2string.substring(dotPos2);
        boolean firstExtensionWild = firstExtension.equals(".*") || firstExtension.equals("");
        boolean bl = secondExtensionWild = secondExtension.equals(".*") || secondExtension.equals("");
        if (!firstExtensionWild && !secondExtensionWild) {
            throw new IllegalArgumentException("Cannot combine patterns: " + this.patternString + " and " + pattern2string);
        }
        return this.parser.parse(file2 + (firstExtensionWild ? secondExtension : firstExtension));
    }

    public boolean equals(Object other) {
        if (!(other instanceof PathPattern)) {
            return false;
        }
        PathPattern otherPattern = (PathPattern)other;
        return this.patternString.equals(otherPattern.getPatternString()) && this.separator == otherPattern.getSeparator() && this.caseSensitive == otherPattern.caseSensitive;
    }

    public int hashCode() {
        return (this.patternString.hashCode() + this.separator) * 17 + (this.caseSensitive ? 1 : 0);
    }

    public String toString() {
        return this.patternString;
    }

    int getScore() {
        return this.score;
    }

    boolean isCatchAll() {
        return this.catchAll;
    }

    int getNormalizedLength() {
        return this.normalizedLength;
    }

    char getSeparator() {
        return this.separator;
    }

    int getCapturedVariableCount() {
        return this.capturedVariableCount;
    }

    String toChainString() {
        StringBuilder buf = new StringBuilder();
        PathElement pe = this.head;
        while (pe != null) {
            buf.append(pe.toString()).append(" ");
            pe = pe.next;
        }
        return buf.toString().trim();
    }

    String computePatternString() {
        StringBuilder buf = new StringBuilder();
        PathElement pe = this.head;
        while (pe != null) {
            buf.append(pe.getChars());
            pe = pe.next;
        }
        return buf.toString();
    }

    @Nullable
    PathElement getHeadSection() {
        return this.head;
    }

    private String concat(String path1, String path2) {
        boolean path2StartsWithSeparator;
        boolean path1EndsWithSeparator = path1.charAt(path1.length() - 1) == this.separator;
        boolean bl = path2StartsWithSeparator = path2.charAt(0) == this.separator;
        if (path1EndsWithSeparator && path2StartsWithSeparator) {
            return path1 + path2.substring(1);
        }
        if (path1EndsWithSeparator || path2StartsWithSeparator) {
            return path1 + path2;
        }
        return path1 + this.separator + path2;
    }

    private boolean hasLength(@Nullable PathContainer container) {
        return container != null && container.elements().size() > 0;
    }

    class MatchingContext {
        final PathContainer candidate;
        final List<PathContainer.Element> pathElements;
        final int pathLength;
        boolean isMatchStartMatching = false;
        @Nullable
        private Map<String, String> extractedUriVariables;
        @Nullable
        private Map<String, MultiValueMap<String, String>> extractedMatrixVariables;
        boolean extractingVariables;
        boolean determineRemainingPath = false;
        int remainingPathIndex;

        public MatchingContext(PathContainer pathContainer, boolean extractVariables) {
            this.candidate = pathContainer;
            this.pathElements = pathContainer.elements();
            this.pathLength = this.pathElements.size();
            this.extractingVariables = extractVariables;
        }

        public void setMatchAllowExtraPath() {
            this.determineRemainingPath = true;
        }

        public boolean isAllowOptionalTrailingSlash() {
            return PathPattern.this.allowOptionalTrailingSlash;
        }

        public void setMatchStartMatching(boolean b) {
            this.isMatchStartMatching = b;
        }

        public void set(String key, String value, MultiValueMap<String, String> parameters) {
            if (this.extractedUriVariables == null) {
                this.extractedUriVariables = new HashMap<String, String>();
            }
            this.extractedUriVariables.put(key, value);
            if (!parameters.isEmpty()) {
                if (this.extractedMatrixVariables == null) {
                    this.extractedMatrixVariables = new HashMap<String, MultiValueMap<String, String>>();
                }
                this.extractedMatrixVariables.put(key, (MultiValueMap<String, String>)CollectionUtils.unmodifiableMultiValueMap(parameters));
            }
        }

        public PathMatchResult getPathMatchResult() {
            if (this.extractedUriVariables == null) {
                return PathMatchResult.EMPTY;
            }
            return new PathMatchResult(this.extractedUriVariables, this.extractedMatrixVariables);
        }

        boolean isSeparator(int pathIndex) {
            return this.pathElements.get(pathIndex) instanceof PathContainer.Separator;
        }

        String pathElementValue(int pathIndex) {
            PathContainer.Element element;
            PathContainer.Element element2 = element = pathIndex < this.pathLength ? this.pathElements.get(pathIndex) : null;
            if (element instanceof PathContainer.PathSegment) {
                return ((PathContainer.PathSegment)element).valueToMatch();
            }
            return "";
        }
    }

    public static class PathRemainingMatchInfo {
        private final PathContainer pathRemaining;
        private final PathMatchResult pathMatchResult;

        PathRemainingMatchInfo(PathContainer pathRemaining) {
            this(pathRemaining, PathMatchResult.EMPTY);
        }

        PathRemainingMatchInfo(PathContainer pathRemaining, PathMatchResult pathMatchResult) {
            this.pathRemaining = pathRemaining;
            this.pathMatchResult = pathMatchResult;
        }

        public PathContainer getPathRemaining() {
            return this.pathRemaining;
        }

        public Map<String, String> getUriVariables() {
            return this.pathMatchResult.getUriVariables();
        }

        public Map<String, MultiValueMap<String, String>> getMatrixVariables() {
            return this.pathMatchResult.getMatrixVariables();
        }
    }

    public static class PathMatchResult {
        private static final PathMatchResult EMPTY = new PathMatchResult(Collections.emptyMap(), Collections.emptyMap());
        private final Map<String, String> uriVariables;
        private final Map<String, MultiValueMap<String, String>> matrixVariables;

        PathMatchResult(Map<String, String> uriVars, @Nullable Map<String, MultiValueMap<String, String>> matrixVars) {
            this.uriVariables = Collections.unmodifiableMap(uriVars);
            this.matrixVariables = matrixVars != null ? Collections.unmodifiableMap(matrixVars) : Collections.emptyMap();
        }

        public Map<String, String> getUriVariables() {
            return this.uriVariables;
        }

        public Map<String, MultiValueMap<String, String>> getMatrixVariables() {
            return this.matrixVariables;
        }

        public String toString() {
            return "PathMatchResult[uriVariables=" + this.uriVariables + ", matrixVariables=" + this.matrixVariables + "]";
        }
    }
}

