/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.AbstractCodecConfigurer;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.FormHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerSentEventHttpMessageReader;
import org.springframework.http.codec.multipart.MultipartHttpMessageWriter;
import org.springframework.lang.Nullable;

class DefaultClientCodecConfigurer
extends AbstractCodecConfigurer
implements ClientCodecConfigurer {
    public DefaultClientCodecConfigurer() {
        super(new ClientDefaultCodecsImpl());
    }

    @Override
    public ClientCodecConfigurer.ClientDefaultCodecs defaultCodecs() {
        return (ClientCodecConfigurer.ClientDefaultCodecs)super.defaultCodecs();
    }

    private static class DefaultMultipartCodecs
    implements ClientCodecConfigurer.MultipartCodecs {
        private final List<HttpMessageWriter<?>> writers = new ArrayList();

        private DefaultMultipartCodecs() {
        }

        @Override
        public ClientCodecConfigurer.MultipartCodecs encoder(Encoder<?> encoder) {
            this.writer(new EncoderHttpMessageWriter(encoder));
            return this;
        }

        @Override
        public ClientCodecConfigurer.MultipartCodecs writer(HttpMessageWriter<?> writer) {
            this.writers.add(writer);
            return this;
        }

        public List<HttpMessageWriter<?>> getWriters() {
            return this.writers;
        }
    }

    private static class ClientDefaultCodecsImpl
    extends AbstractCodecConfigurer.AbstractDefaultCodecs
    implements ClientCodecConfigurer.ClientDefaultCodecs {
        @Nullable
        private DefaultMultipartCodecs multipartCodecs;
        @Nullable
        private Decoder<?> sseDecoder;

        private ClientDefaultCodecsImpl() {
        }

        @Override
        public ClientCodecConfigurer.MultipartCodecs multipartCodecs() {
            if (this.multipartCodecs == null) {
                this.multipartCodecs = new DefaultMultipartCodecs();
            }
            return this.multipartCodecs;
        }

        @Override
        public void serverSentEventDecoder(Decoder<?> decoder) {
            this.sseDecoder = decoder;
        }

        @Override
        protected boolean splitTextOnNewLine() {
            return false;
        }

        @Override
        public List<HttpMessageReader<?>> getObjectReaders() {
            if (!this.shouldRegisterDefaults()) {
                return Collections.emptyList();
            }
            List<HttpMessageReader<?>> result = super.getObjectReaders();
            result.add(new ServerSentEventHttpMessageReader(this.getSseDecoder()));
            return result;
        }

        private Decoder<?> getSseDecoder() {
            if (this.sseDecoder != null) {
                return this.sseDecoder;
            }
            return AbstractCodecConfigurer.jackson2Present ? this.jackson2JsonDecoder() : null;
        }

        @Override
        public List<HttpMessageWriter<?>> getTypedWriters() {
            if (!this.shouldRegisterDefaults()) {
                return Collections.emptyList();
            }
            List<HttpMessageWriter<?>> result = super.getTypedWriters();
            result.add(new FormHttpMessageWriter());
            result.add(this.getMultipartHttpMessageWriter());
            return result;
        }

        private MultipartHttpMessageWriter getMultipartHttpMessageWriter() {
            List<HttpMessageWriter<?>> partWriters;
            if (this.multipartCodecs != null) {
                partWriters = this.multipartCodecs.getWriters();
            } else {
                AbstractCodecConfigurer.DefaultCustomCodecs customCodecs = this.getCustomCodecs();
                partWriters = new ArrayList();
                partWriters.addAll(super.getTypedWriters());
                if (customCodecs != null) {
                    partWriters.addAll(customCodecs.getTypedWriters());
                }
                partWriters.addAll(super.getObjectWriters());
                if (customCodecs != null) {
                    partWriters.addAll(customCodecs.getObjectWriters());
                }
                partWriters.addAll(super.getCatchAllWriters());
            }
            return new MultipartHttpMessageWriter(partWriters);
        }
    }
}

