/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.HttpServletContextMap;
import org.springframework.webflow.context.servlet.HttpServletRequestMap;
import org.springframework.webflow.context.servlet.HttpServletRequestParameterMap;
import org.springframework.webflow.context.servlet.HttpSessionMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class ServletExternalContext
implements ExternalContext {
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public ServletExternalContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getDispatcherPath() {
        return this.request.getServletPath();
    }

    public String getRequestPathInfo() {
        return this.request.getPathInfo();
    }

    public ParameterMap getRequestParameterMap() {
        return new LocalParameterMap((Map)((Object)new HttpServletRequestParameterMap(this.request)));
    }

    public MutableAttributeMap getRequestMap() {
        return new LocalAttributeMap((Map)((Object)new HttpServletRequestMap(this.request)));
    }

    public SharedAttributeMap getSessionMap() {
        return new LocalSharedAttributeMap(new HttpSessionMap(this.request));
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return this.getSessionMap();
    }

    public SharedAttributeMap getApplicationMap() {
        return new LocalSharedAttributeMap(new HttpServletContextMap(this.context));
    }

    public ServletContext getContext() {
        return this.context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("requestParameterMap", (Object)this.getRequestParameterMap()).toString();
    }
}

