/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.springframework.binding.expression.Expression;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.MappingBuilder;
import org.springframework.binding.method.MethodSignature;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.action.ActionResultExposer;
import org.springframework.webflow.action.BeanInvokingActionFactory;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.engine.AnnotatedAction;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowAttributeMapper;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.engine.builder.BaseFlowBuilder;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.FlowArtifactLookupException;
import org.springframework.webflow.engine.builder.FlowBuilderException;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.support.ActionTransitionCriteria;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ScopeType;
import org.springframework.webflow.execution.support.EventFactorySupport;

public abstract class AbstractFlowBuilder
extends BaseFlowBuilder {
    private EventFactorySupport eventFactorySupport = new EventFactorySupport();
    static /* synthetic */ Class class$org$springframework$webflow$engine$ViewSelector;
    static /* synthetic */ Class class$org$springframework$binding$method$MethodSignature;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TargetStateResolver;

    protected AbstractFlowBuilder() {
    }

    protected AbstractFlowBuilder(FlowServiceLocator flowServiceLocator) {
        super(flowServiceLocator);
    }

    public EventFactorySupport getEventFactorySupport() {
        return this.eventFactorySupport;
    }

    public void setEventFactorySupport(EventFactorySupport eventFactorySupport) {
        this.eventFactorySupport = eventFactorySupport;
    }

    public void init(String flowId, AttributeMap attributes) throws FlowBuilderException {
        this.setFlow(this.getFlowArtifactFactory().createFlow(flowId, this.flowAttributes().union(attributes)));
    }

    protected AttributeMap flowAttributes() {
        return CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    }

    protected State addViewState(String stateId, String viewName, Transition transition) {
        return this.getFlowArtifactFactory().createViewState(stateId, this.getFlow(), null, this.viewSelector(viewName), null, new Transition[]{transition}, null, null, null);
    }

    protected State addViewState(String stateId, String viewName, Transition[] transitions) {
        return this.getFlowArtifactFactory().createViewState(stateId, this.getFlow(), null, this.viewSelector(viewName), null, transitions, null, null, null);
    }

    protected State addViewState(String stateId, String viewName, Action renderAction, Transition transition) {
        return this.getFlowArtifactFactory().createViewState(stateId, this.getFlow(), null, this.viewSelector(viewName), new Action[]{renderAction}, new Transition[]{transition}, null, null, null);
    }

    protected State addViewState(String stateId, String viewName, Action renderAction, Transition[] transitions) {
        return this.getFlowArtifactFactory().createViewState(stateId, this.getFlow(), null, this.viewSelector(viewName), new Action[]{renderAction}, transitions, null, null, null);
    }

    protected State addViewState(String stateId, Action[] entryActions, ViewSelector viewSelector, Action[] renderActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        return this.getFlowArtifactFactory().createViewState(stateId, this.getFlow(), entryActions, viewSelector, renderActions, transitions, exceptionHandlers, exitActions, attributes);
    }

    protected State addActionState(String stateId, Action action, Transition transition) {
        return this.getFlowArtifactFactory().createActionState(stateId, this.getFlow(), null, new Action[]{action}, new Transition[]{transition}, null, null, null);
    }

    protected State addActionState(String stateId, Action action, Transition[] transitions) {
        return this.getFlowArtifactFactory().createActionState(stateId, this.getFlow(), null, new Action[]{action}, transitions, null, null, null);
    }

    protected State addActionState(String stateId, Action action, Transition transition, FlowExecutionExceptionHandler exceptionHandler) {
        return this.getFlowArtifactFactory().createActionState(stateId, this.getFlow(), null, new Action[]{action}, new Transition[]{transition}, new FlowExecutionExceptionHandler[]{exceptionHandler}, null, null);
    }

    protected State addActionState(String stateId, Action[] entryActions, Action[] actions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        return this.getFlowArtifactFactory().createActionState(stateId, this.getFlow(), entryActions, actions, transitions, exceptionHandlers, exitActions, attributes);
    }

    protected State addDecisionState(String stateId, Transition[] transitions) {
        return this.getFlowArtifactFactory().createDecisionState(stateId, this.getFlow(), null, transitions, null, null, null);
    }

    protected State addDecisionState(String stateId, TransitionCriteria decisionCriteria, String trueStateId, String falseStateId) {
        Transition thenTransition = this.getFlowArtifactFactory().createTransition(this.to(trueStateId), decisionCriteria, null, null);
        Transition elseTransition = this.getFlowArtifactFactory().createTransition(this.to(falseStateId), null, null, null);
        return this.getFlowArtifactFactory().createDecisionState(stateId, this.getFlow(), null, new Transition[]{thenTransition, elseTransition}, null, null, null);
    }

    protected State addDecisionState(String stateId, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        return this.getFlowArtifactFactory().createDecisionState(stateId, this.getFlow(), entryActions, transitions, exceptionHandlers, exitActions, attributes);
    }

    protected State addSubflowState(String stateId, Flow subflow, FlowAttributeMapper attributeMapper, Transition transition) {
        return this.getFlowArtifactFactory().createSubflowState(stateId, this.getFlow(), null, subflow, attributeMapper, new Transition[]{transition}, null, null, null);
    }

    protected State addSubflowState(String stateId, Flow subflow, FlowAttributeMapper attributeMapper, Transition[] transitions) {
        return this.getFlowArtifactFactory().createSubflowState(stateId, this.getFlow(), null, subflow, attributeMapper, transitions, null, null, null);
    }

    protected State addSubflowState(String stateId, Action[] entryActions, Flow subflow, FlowAttributeMapper attributeMapper, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        return this.getFlowArtifactFactory().createSubflowState(stateId, this.getFlow(), entryActions, subflow, attributeMapper, transitions, exceptionHandlers, exitActions, attributes);
    }

    protected State addEndState(String stateId) {
        return this.getFlowArtifactFactory().createEndState(stateId, this.getFlow(), null, null, null, null, null);
    }

    protected State addEndState(String stateId, String viewName) {
        return this.getFlowArtifactFactory().createEndState(stateId, this.getFlow(), null, this.viewSelector(viewName), null, null, null);
    }

    protected State addEndState(String stateId, String viewName, AttributeMapper outputMapper) {
        return this.getFlowArtifactFactory().createEndState(stateId, this.getFlow(), null, this.viewSelector(viewName), outputMapper, null, null);
    }

    protected State addEndState(String stateId, Action[] entryActions, ViewSelector viewSelector, AttributeMapper outputMapper, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeMap attributes) {
        return this.getFlowArtifactFactory().createEndState(stateId, this.getFlow(), entryActions, viewSelector, outputMapper, exceptionHandlers, attributes);
    }

    public ViewSelector viewSelector(String viewName) {
        return (ViewSelector)this.fromStringTo(class$org$springframework$webflow$engine$ViewSelector == null ? (class$org$springframework$webflow$engine$ViewSelector = AbstractFlowBuilder.class$("org.springframework.webflow.engine.ViewSelector")) : class$org$springframework$webflow$engine$ViewSelector).execute((Object)viewName);
    }

    protected Action action(String id) throws FlowArtifactLookupException {
        return this.getFlowServiceLocator().getAction(id);
    }

    protected Action action(String beanId, MethodSignature methodSignature) throws FlowArtifactLookupException {
        return this.getBeanInvokingActionFactory().createBeanInvokingAction(beanId, this.getFlowServiceLocator().getBeanFactory(), methodSignature, null, this.getFlowServiceLocator().getConversionService(), null);
    }

    protected Action action(String beanId, MethodSignature methodSignature, ActionResultExposer resultExposer) throws FlowArtifactLookupException {
        return this.getBeanInvokingActionFactory().createBeanInvokingAction(beanId, this.getFlowServiceLocator().getBeanFactory(), methodSignature, resultExposer, this.getFlowServiceLocator().getConversionService(), null);
    }

    protected Action action(Expression expression) {
        return this.action(expression, null);
    }

    protected Action action(Expression expression, ActionResultExposer resultExposer) {
        return new EvaluateAction(expression, resultExposer);
    }

    protected Expression expression(String expressionString) {
        return this.getFlowServiceLocator().getExpressionParser().parseExpression(expressionString);
    }

    protected MethodSignature method(String method) {
        return (MethodSignature)this.fromStringTo(class$org$springframework$binding$method$MethodSignature == null ? (class$org$springframework$binding$method$MethodSignature = AbstractFlowBuilder.class$("org.springframework.binding.method.MethodSignature")) : class$org$springframework$binding$method$MethodSignature).execute((Object)method);
    }

    protected ActionResultExposer result(String resultName) {
        return this.result(resultName, ScopeType.REQUEST);
    }

    protected ActionResultExposer result(String resultName, ScopeType resultScope) {
        return new ActionResultExposer(resultName, resultScope);
    }

    protected AnnotatedAction invoke(String methodName, MultiAction multiAction) throws FlowArtifactLookupException {
        AnnotatedAction action = new AnnotatedAction(multiAction);
        action.setMethod(methodName);
        return action;
    }

    protected FlowAttributeMapper attributeMapper(String id) throws FlowArtifactLookupException {
        return this.getFlowServiceLocator().getAttributeMapper(id);
    }

    protected Flow flow(String id) throws FlowArtifactLookupException {
        return this.getFlowServiceLocator().getSubflow(id);
    }

    protected TransitionCriteria on(String transitionCriteriaExpression) {
        return (TransitionCriteria)this.fromStringTo(class$org$springframework$webflow$engine$TransitionCriteria == null ? (class$org$springframework$webflow$engine$TransitionCriteria = AbstractFlowBuilder.class$("org.springframework.webflow.engine.TransitionCriteria")) : class$org$springframework$webflow$engine$TransitionCriteria).execute((Object)transitionCriteriaExpression);
    }

    protected TargetStateResolver to(String targetStateIdExpression) {
        return (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$engine$TargetStateResolver == null ? (class$org$springframework$webflow$engine$TargetStateResolver = AbstractFlowBuilder.class$("org.springframework.webflow.engine.TargetStateResolver")) : class$org$springframework$webflow$engine$TargetStateResolver).execute((Object)targetStateIdExpression);
    }

    protected Transition transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver) {
        return this.getFlowArtifactFactory().createTransition(targetStateResolver, matchingCriteria, null, null);
    }

    protected Transition transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver, TransitionCriteria executionCriteria) {
        return this.getFlowArtifactFactory().createTransition(targetStateResolver, matchingCriteria, executionCriteria, null);
    }

    protected Transition transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver, TransitionCriteria executionCriteria, AttributeMap attributes) {
        return this.getFlowArtifactFactory().createTransition(targetStateResolver, matchingCriteria, executionCriteria, attributes);
    }

    protected TransitionCriteria ifReturnedSuccess(Action action) {
        return new ActionTransitionCriteria(action);
    }

    protected String success() {
        return this.eventFactorySupport.getSuccessEventId();
    }

    protected String error() {
        return this.eventFactorySupport.getErrorEventId();
    }

    protected String submit() {
        return "submit";
    }

    protected String back() {
        return "back";
    }

    protected String cancel() {
        return "cancel";
    }

    protected String finish() {
        return "finish";
    }

    protected String select() {
        return "select";
    }

    protected String edit() {
        return "edit";
    }

    protected String add() {
        return "add";
    }

    protected String delete() {
        return "delete";
    }

    protected String yes() {
        return this.eventFactorySupport.getYesEventId();
    }

    protected String no() {
        return this.eventFactorySupport.getNoEventId();
    }

    protected MappingBuilder mapping() {
        MappingBuilder mapping = new MappingBuilder(this.getFlowServiceLocator().getExpressionParser());
        mapping.setConversionService(this.getFlowServiceLocator().getConversionService());
        return mapping;
    }

    public String toString() {
        return new ToStringCreator((Object)this).toString();
    }

    private FlowArtifactFactory getFlowArtifactFactory() {
        return this.getFlowServiceLocator().getFlowArtifactFactory();
    }

    private BeanInvokingActionFactory getBeanInvokingActionFactory() {
        return this.getFlowServiceLocator().getBeanInvokingActionFactory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

