/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.mvc;

import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;
import org.springframework.webflow.context.portlet.PortletExternalContext;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;

public class PortletFlowController
extends AbstractController
implements InitializingBean {
    private static final String RESPONSE_INSTRUCTION_SESSION_ATTRIBUTE = "actionRequest.responseInstruction";
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentHandler argumentHandler = new RequestParameterFlowExecutorArgumentHandler();

    public PortletFlowController() {
        this.setCacheSeconds(0);
        this.setSynchronizeOnSession(true);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowExecutorArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }

    public void setArgumentHandler(FlowExecutorArgumentHandler argumentHandler) {
        this.argumentHandler = argumentHandler;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.argumentHandler.setDefaultFlowId(defaultFlowId);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.flowExecutor, (String)"The flow executor property is required");
        Assert.notNull((Object)this.argumentHandler, (String)"The argument handler property is required");
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        PortletExternalContext context = new PortletExternalContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        if (this.argumentHandler.isFlowExecutionKeyPresent(context)) {
            String flowExecutionKey = this.argumentHandler.extractFlowExecutionKey(context);
            ResponseInstruction responseInstruction = this.extractActionResponseInstruction((PortletRequest)request);
            if (responseInstruction == null) {
                return this.toModelAndView(this.flowExecutor.refresh(flowExecutionKey, context));
            }
            return this.toModelAndView(responseInstruction);
        }
        ResponseInstruction responseInstruction = this.extractActionResponseInstruction((PortletRequest)request);
        if (responseInstruction == null) {
            String flowId = this.argumentHandler.extractFlowId(context);
            return this.toModelAndView(this.flowExecutor.launch(flowId, context));
        }
        return this.toModelAndView(responseInstruction);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        String eventId;
        PortletExternalContext context = new PortletExternalContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        String flowExecutionKey = this.argumentHandler.extractFlowExecutionKey(context);
        ResponseInstruction responseInstruction = this.flowExecutor.resume(flowExecutionKey, eventId = this.argumentHandler.extractEventId(context), context);
        if (responseInstruction.isApplicationView()) {
            if (responseInstruction.isActiveView()) {
                response.setRenderParameter(this.argumentHandler.getFlowExecutionKeyArgumentName(), responseInstruction.getFlowExecutionKey());
            }
            this.exposeToRenderPhase(responseInstruction, request);
        } else if (responseInstruction.isFlowExecutionRedirect()) {
            response.setRenderParameter(this.argumentHandler.getFlowExecutionKeyArgumentName(), responseInstruction.getFlowExecutionKey());
        } else if (responseInstruction.isFlowDefinitionRedirect()) {
            FlowDefinitionRedirect redirect = (FlowDefinitionRedirect)responseInstruction.getViewSelection();
            response.setRenderParameters(redirect.getExecutionInput());
            response.setRenderParameter(this.argumentHandler.getFlowIdArgumentName(), redirect.getFlowDefinitionId());
        } else if (responseInstruction.isExternalRedirect()) {
            ExternalRedirect redirect = (ExternalRedirect)responseInstruction.getViewSelection();
            String url = this.argumentHandler.createExternalUrl(redirect, flowExecutionKey, context);
            response.sendRedirect(url);
        } else {
            throw new IllegalArgumentException("Don't know how to handle response instruction " + responseInstruction);
        }
    }

    private void exposeToRenderPhase(ResponseInstruction responseInstruction, ActionRequest request) {
        PortletSession session = request.getPortletSession(false);
        Assert.notNull((Object)session, (String)"A PortletSession is required");
        session.setAttribute(RESPONSE_INSTRUCTION_SESSION_ATTRIBUTE, (Object)responseInstruction);
    }

    private ResponseInstruction extractActionResponseInstruction(PortletRequest request) {
        PortletSession session = request.getPortletSession(false);
        ResponseInstruction response = null;
        if (session != null && (response = (ResponseInstruction)session.getAttribute(RESPONSE_INSTRUCTION_SESSION_ATTRIBUTE)) != null) {
            session.removeAttribute(RESPONSE_INSTRUCTION_SESSION_ATTRIBUTE);
        }
        return response;
    }

    protected ModelAndView toModelAndView(ResponseInstruction response) {
        if (response.isApplicationView()) {
            ApplicationView forward = (ApplicationView)response.getViewSelection();
            HashMap model = new HashMap(forward.getModel());
            this.argumentHandler.exposeFlowExecutionContext(response.getFlowExecutionKey(), response.getFlowExecutionContext(), model);
            return new ModelAndView(forward.getViewName(), model);
        }
        if (response.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Don't know how to handle response instruction " + response);
    }
}

