/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.web.jsf.DecoratingNavigationHandler;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.executor.RequestParameterInputMapper;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;
import org.springframework.webflow.executor.jsf.FlowFacesUtils;
import org.springframework.webflow.executor.jsf.FlowNavigationHandlerArgumentExtractor;
import org.springframework.webflow.executor.jsf.JsfExternalContext;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;

public class FlowNavigationHandler
extends DecoratingNavigationHandler {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private FlowExecutorArgumentExtractor argumentExtractor = new FlowNavigationHandlerArgumentExtractor();
    private AttributeMapper inputMapper = new RequestParameterInputMapper();

    public FlowNavigationHandler() {
    }

    public FlowNavigationHandler(NavigationHandler originalNavigationHandler) {
        super(originalNavigationHandler);
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public void setArgumentExtractor(FlowExecutorArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public AttributeMapper getInputMapper() {
        return this.inputMapper;
    }

    public void setInputMapper(AttributeMapper inputMapper) {
        this.inputMapper = inputMapper;
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome, NavigationHandler originalNavigationHandler) {
        JsfExternalContext context = new JsfExternalContext(facesContext, fromAction, outcome);
        if (this.argumentExtractor.isFlowIdPresent(context)) {
            String flowId = this.argumentExtractor.extractFlowId(context);
            FlowDefinition flowDefinition = this.getLocator(context).getFlowDefinition(flowId);
            FlowExecution flowExecution = this.getFactory(context).createFlowExecution(flowDefinition);
            if (FlowExecutionHolderUtils.isFlowExecutionRestored(facesContext)) {
                FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext).replaceWith(flowExecution);
            } else {
                FlowExecutionHolder holder = new FlowExecutionHolder(flowExecution);
                FlowExecutionHolderUtils.setFlowExecutionHolder(holder, facesContext);
            }
            ViewSelection selectedView = flowExecution.start(this.createInput(context), context);
            FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext).setViewSelection(selectedView);
        } else if (FlowExecutionHolderUtils.isFlowExecutionRestored(facesContext)) {
            if (this.argumentExtractor.isEventIdPresent(context)) {
                String eventId = this.argumentExtractor.extractEventId(context);
                FlowExecutionHolder holder = FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext);
                ViewSelection selectedView = holder.getFlowExecution().signalEvent(eventId, context);
                holder.setViewSelection(selectedView);
            }
        } else {
            originalNavigationHandler.handleNavigation(facesContext, fromAction, outcome);
        }
    }

    protected MutableAttributeMap createInput(ExternalContext context) {
        if (this.inputMapper != null) {
            LocalAttributeMap inputMap = new LocalAttributeMap();
            this.inputMapper.map((Object)context, (Object)inputMap, null);
            return inputMap;
        }
        return null;
    }

    private FlowDefinitionLocator getLocator(JsfExternalContext context) {
        return FlowFacesUtils.getDefinitionLocator(context.getFacesContext());
    }

    private FlowExecutionFactory getFactory(JsfExternalContext context) {
        return FlowFacesUtils.getExecutionFactory(context.getFacesContext());
    }
}

