/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import javax.faces.context.FacesContext;
import org.springframework.binding.collection.SharedMap;
import org.springframework.binding.collection.SharedMapDecorator;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class JsfExternalContext
implements ExternalContext {
    private FacesContext facesContext;
    private String actionId;
    private String outcome;
    private ParameterMap requestParameterMap;
    private MutableAttributeMap requestMap;
    private SharedAttributeMap sessionMap;
    private SharedAttributeMap applicationMap;

    public JsfExternalContext(FacesContext facesContext) {
        this.facesContext = facesContext;
        this.initMaps(facesContext);
    }

    public JsfExternalContext(FacesContext facesContext, String actionId, String outcome) {
        this.facesContext = facesContext;
        this.actionId = actionId;
        this.outcome = outcome;
        this.initMaps(facesContext);
    }

    private void initMaps(FacesContext facesContext) {
        this.requestParameterMap = new LocalParameterMap(facesContext.getExternalContext().getRequestParameterMap());
        this.requestMap = new LocalAttributeMap(facesContext.getExternalContext().getRequestMap());
        this.sessionMap = new LocalSharedAttributeMap((SharedMap)new SessionSharedMap(facesContext));
        this.applicationMap = new LocalSharedAttributeMap((SharedMap)new ApplicationSharedMap(facesContext));
    }

    public String getContextPath() {
        return this.facesContext.getExternalContext().getRequestContextPath();
    }

    public String getDispatcherPath() {
        return this.facesContext.getExternalContext().getRequestServletPath();
    }

    public String getRequestPathInfo() {
        return this.facesContext.getExternalContext().getRequestPathInfo();
    }

    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public MutableAttributeMap getRequestMap() {
        return this.requestMap;
    }

    public SharedAttributeMap getSessionMap() {
        return this.sessionMap;
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return this.getSessionMap();
    }

    public SharedAttributeMap getApplicationMap() {
        return this.applicationMap;
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public String getActionId() {
        return this.actionId;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("actionId", (Object)this.actionId).append("outcome", (Object)this.outcome).append("facesContext", (Object)this.facesContext).toString();
    }

    private static class ApplicationSharedMap
    extends SharedMapDecorator {
        private FacesContext facesContext;

        public ApplicationSharedMap(FacesContext facesContext) {
            super(facesContext.getExternalContext().getApplicationMap());
            this.facesContext = facesContext;
        }

        public Object getMutex() {
            return this.facesContext.getExternalContext().getContext();
        }
    }

    private static class SessionSharedMap
    extends SharedMapDecorator {
        private FacesContext facesContext;

        public SessionSharedMap(FacesContext facesContext) {
            super(facesContext.getExternalContext().getSessionMap());
            this.facesContext = facesContext;
        }

        public Object getMutex() {
            return this.facesContext.getExternalContext().getSession(false);
        }
    }
}

