/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockExternalContext;
import org.springframework.webflow.test.MockFlowExecutionContext;

public class MockRequestContext
implements RequestContext {
    private FlowExecutionContext flowExecutionContext = new MockFlowExecutionContext();
    private ExternalContext externalContext = new MockExternalContext();
    private MutableAttributeMap requestScope = new LocalAttributeMap();
    private Event lastEvent;
    private Transition lastTransition;
    private MutableAttributeMap attributes = new LocalAttributeMap();

    public MockRequestContext() {
    }

    public MockRequestContext(Flow flow) {
        this.flowExecutionContext = new MockFlowExecutionContext(flow);
    }

    public MockRequestContext(ParameterMap requestParameterMap) {
        this.externalContext = new MockExternalContext(requestParameterMap);
    }

    public FlowDefinition getActiveFlow() {
        return this.getFlowExecutionContext().getActiveSession().getDefinition();
    }

    public StateDefinition getCurrentState() {
        return this.getFlowExecutionContext().getActiveSession().getState();
    }

    public MutableAttributeMap getRequestScope() {
        return this.requestScope;
    }

    public MutableAttributeMap getFlashScope() {
        return this.getMockFlowExecutionContext().getActiveSession().getFlashMap();
    }

    public MutableAttributeMap getFlowScope() {
        return this.getFlowExecutionContext().getActiveSession().getScope();
    }

    public MutableAttributeMap getConversationScope() {
        return this.getMockFlowExecutionContext().getConversationScope();
    }

    public ParameterMap getRequestParameters() {
        return this.externalContext.getRequestParameterMap();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecutionContext;
    }

    public Event getLastEvent() {
        return this.lastEvent;
    }

    public TransitionDefinition getLastTransition() {
        return this.lastTransition;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeMap attributes) {
        this.attributes.replaceWith(attributes);
    }

    public AttributeMap getModel() {
        return this.getConversationScope().union(this.getFlowScope()).union(this.getFlashScope()).union(this.getRequestScope());
    }

    public void setActiveSession(FlowSession flowSession) {
        this.getMockFlowExecutionContext().setActiveSession(flowSession);
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public void setFlowExecutionContext(FlowExecutionContext flowExecutionContext) {
        this.flowExecutionContext = flowExecutionContext;
    }

    public void setLastEvent(Event lastEvent) {
        this.lastEvent = lastEvent;
    }

    public void setLastTransition(Transition lastTransition) {
        this.lastTransition = lastTransition;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    public MutableAttributeMap getAttributeMap() {
        return this.attributes;
    }

    public MockFlowExecutionContext getMockFlowExecutionContext() {
        return (MockFlowExecutionContext)this.flowExecutionContext;
    }

    public MockExternalContext getMockExternalContext() {
        return (MockExternalContext)this.externalContext;
    }

    public void putRequestParameter(String parameterName, String parameterValue) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, String[] parameterValues) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValues);
    }
}

