/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test.execution;

import java.io.File;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionResource;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;
import org.springframework.webflow.test.MockFlowServiceLocator;
import org.springframework.webflow.test.execution.AbstractFlowExecutionTests;

public abstract class AbstractExternalizedFlowExecutionTests
extends AbstractFlowExecutionTests {
    private static FlowDefinition cachedFlowDefinition;
    private boolean cacheFlowDefinition = false;

    public AbstractExternalizedFlowExecutionTests() {
    }

    public AbstractExternalizedFlowExecutionTests(String name) {
        super(name);
    }

    private FlowExecutionImplFactory getFlowExecutionImplFactory() {
        return (FlowExecutionImplFactory)this.getFlowExecutionFactory();
    }

    protected boolean isCacheFlowDefinition() {
        return this.cacheFlowDefinition;
    }

    protected void setCacheFlowDefinition(boolean cacheFlowDefinition) {
        this.cacheFlowDefinition = cacheFlowDefinition;
    }

    protected void setFlowExecutionAttributes(AttributeMap executionAttributes) {
        this.getFlowExecutionImplFactory().setExecutionAttributes(executionAttributes);
    }

    protected void setFlowExecutionListener(FlowExecutionListener executionListener) {
        this.getFlowExecutionImplFactory().setExecutionListenerLoader(new StaticFlowExecutionListenerLoader(executionListener));
    }

    protected final FlowDefinition getFlowDefinition() {
        if (this.isCacheFlowDefinition() && cachedFlowDefinition != null) {
            return cachedFlowDefinition;
        }
        FlowServiceLocator flowServiceLocator = this.createFlowServiceLocator();
        Flow flow = this.createFlow(this.getFlowDefinitionResource(), flowServiceLocator);
        if (this.isCacheFlowDefinition()) {
            cachedFlowDefinition = flow;
        }
        return flow;
    }

    protected FlowServiceLocator createFlowServiceLocator() {
        MockFlowServiceLocator serviceLocator = new MockFlowServiceLocator();
        this.registerMockServices(serviceLocator);
        return serviceLocator;
    }

    protected void registerMockServices(MockFlowServiceLocator serviceRegistry) {
    }

    protected final Flow createFlow(FlowDefinitionResource resource, FlowServiceLocator serviceLocator) {
        FlowBuilder builder = this.createFlowBuilder(resource.getLocation(), serviceLocator);
        FlowAssembler assembler = new FlowAssembler(resource.getId(), resource.getAttributes(), builder);
        return assembler.assembleFlow();
    }

    protected abstract FlowDefinitionResource getFlowDefinitionResource();

    protected abstract FlowBuilder createFlowBuilder(Resource var1, FlowServiceLocator var2);

    protected final FlowDefinitionResource createFlowDefinitionResource(String filePath) {
        return this.createFlowDefinitionResource(new File(filePath));
    }

    protected final FlowDefinitionResource createFlowDefinitionResource(String fileDirectory, String fileName) {
        return this.createFlowDefinitionResource(new File(fileDirectory, fileName));
    }

    protected FlowDefinitionResource createFlowDefinitionResource(File file) {
        return new FlowDefinitionResource((Resource)new FileSystemResource(file));
    }
}

