/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.factory;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.ConditionalFlowExecutionListenerHolder;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteria;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteriaFactory;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;

public class ConditionalFlowExecutionListenerLoader
implements FlowExecutionListenerLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List listeners = new LinkedList();
    static /* synthetic */ Class class$org$springframework$webflow$execution$FlowExecutionListener;

    public void addListener(FlowExecutionListener listener) {
        this.addListener(listener, null);
    }

    public void addListeners(FlowExecutionListener[] listeners, FlowExecutionListenerCriteria criteria) {
        for (int i = 0; i < listeners.length; ++i) {
            this.addListener(listeners[i], criteria);
        }
    }

    public void addListener(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        ConditionalFlowExecutionListenerHolder conditional;
        if (listener == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding flow execution listener " + listener + " with criteria " + criteria));
        }
        if ((conditional = this.getHolder(listener)) == null) {
            conditional = new ConditionalFlowExecutionListenerHolder(listener);
            this.listeners.add(conditional);
        }
        if (criteria == null) {
            criteria = new FlowExecutionListenerCriteriaFactory().allFlows();
        }
        conditional.add(criteria);
    }

    public void setListeners(Map listenersWithCriteria) {
        this.removeAllListeners();
        Iterator it = listenersWithCriteria.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Assert.isInstanceOf((Class)(class$org$springframework$webflow$execution$FlowExecutionListener == null ? ConditionalFlowExecutionListenerLoader.class$("org.springframework.webflow.execution.FlowExecutionListener") : class$org$springframework$webflow$execution$FlowExecutionListener), entry.getKey(), (String)"The key in the listenersWithCriteria map needs to be a FlowExecutionListener object");
            FlowExecutionListener listener = (FlowExecutionListener)entry.getKey();
            FlowExecutionListenerCriteria criteria = null;
            if (entry.getValue() instanceof String) {
                criteria = this.getCriteria((String)entry.getValue());
            } else if (entry.getValue() instanceof FlowExecutionListenerCriteria) {
                criteria = (FlowExecutionListenerCriteria)entry.getValue();
            } else if (entry.getValue() != null) {
                throw new IllegalArgumentException("The value in the listenersWithCriteria map needs to be a String or a FlowExecutionListenerCriteria object");
            }
            this.addListener(listener, criteria);
        }
    }

    public boolean containsListener(FlowExecutionListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder h = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!h.getListener().equals(listener)) continue;
            return true;
        }
        return false;
    }

    public void removeListener(FlowExecutionListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder h = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!h.getListener().equals(listener)) continue;
            it.remove();
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void removeListenerCriteria(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        if (this.containsListener(listener)) {
            ConditionalFlowExecutionListenerHolder listenerHolder = this.getHolder(listener);
            listenerHolder.remove(criteria);
            if (listenerHolder.isCriteriaSetEmpty()) {
                this.removeListener(listener);
            }
        }
    }

    public FlowExecutionListener[] getListeners(FlowDefinition flowDefinition) {
        Assert.notNull((Object)flowDefinition, (String)"The Flow to load listeners for cannot be null");
        LinkedList<FlowExecutionListener> listenersToAttach = new LinkedList<FlowExecutionListener>();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder listenerHolder = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!listenerHolder.listenerAppliesTo(flowDefinition)) continue;
            listenersToAttach.add(listenerHolder.getListener());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded [" + listenersToAttach.size() + "] of possible " + this.listeners.size() + " listeners for this execution request for flow '" + flowDefinition.getId() + "', the listeners to attach are " + StylerUtils.style(listenersToAttach)));
        }
        return listenersToAttach.toArray(new FlowExecutionListener[listenersToAttach.size()]);
    }

    private ConditionalFlowExecutionListenerHolder getHolder(FlowExecutionListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder next = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!next.getListener().equals(listener)) continue;
            return next;
        }
        return null;
    }

    protected FlowExecutionListenerCriteria getCriteria(String value) {
        if ("*".equals(value)) {
            return new FlowExecutionListenerCriteriaFactory().allFlows();
        }
        String[] flowIds = StringUtils.commaDelimitedListToStringArray((String)value);
        for (int i = 0; i < flowIds.length; ++i) {
            flowIds[i] = flowIds[i].trim();
        }
        return new FlowExecutionListenerCriteriaFactory().flows(flowIds);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

