/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.core.NestedRuntimeException;
import org.springframework.http.MediaType;

public class UnsupportedMediaTypeException
extends NestedRuntimeException {
    private final MediaType contentType;
    private final List<MediaType> supportedMediaTypes;

    public UnsupportedMediaTypeException(String reason) {
        super(reason);
        this.contentType = null;
        this.supportedMediaTypes = Collections.emptyList();
    }

    public UnsupportedMediaTypeException(MediaType contentType2, List<MediaType> supportedMediaTypes) {
        super("Content type '" + contentType2 + "' not supported");
        this.contentType = contentType2;
        this.supportedMediaTypes = Collections.unmodifiableList(supportedMediaTypes);
    }

    public Optional<MediaType> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }
}

