/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Mono;

class DefaultClientRequestBuilder
implements ClientRequest.Builder {
    private final HttpMethod method;
    private final URI url;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, String> cookies = new LinkedMultiValueMap();
    private BodyInserter<?, ? super ClientHttpRequest> inserter = BodyInserters.empty();

    public DefaultClientRequestBuilder(HttpMethod method2, URI url) {
        this.method = method2;
        this.url = url;
    }

    @Override
    public ClientRequest.Builder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ClientRequest.Builder headers(HttpHeaders headers2) {
        if (headers2 != null) {
            this.headers.putAll((Map)headers2);
        }
        return this;
    }

    @Override
    public ClientRequest.Builder cookie(String name, String value) {
        this.cookies.add((Object)name, (Object)value);
        return this;
    }

    @Override
    public ClientRequest.Builder cookies(MultiValueMap<String, String> cookies) {
        if (cookies != null) {
            this.cookies.putAll(cookies);
        }
        return this;
    }

    @Override
    public <S, P extends Publisher<S>> ClientRequest.Builder body(P publisher, Class<S> elementClass) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        this.inserter = BodyInserters.fromPublisher(publisher, elementClass);
        return this;
    }

    @Override
    public ClientRequest.Builder body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
        this.inserter = inserter != null ? inserter : BodyInserters.empty();
        return this;
    }

    @Override
    public ClientRequest build() {
        return new BodyInserterRequest(this.method, this.url, this.headers, this.cookies, this.inserter);
    }

    private static class BodyInserterRequest
    implements ClientRequest {
        private final HttpMethod method;
        private final URI url;
        private final HttpHeaders headers;
        private final MultiValueMap<String, String> cookies;
        private final BodyInserter<?, ? super ClientHttpRequest> inserter;

        public BodyInserterRequest(HttpMethod method2, URI url, HttpHeaders headers2, MultiValueMap<String, String> cookies, BodyInserter<?, ? super ClientHttpRequest> inserter) {
            this.method = method2;
            this.url = url;
            this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers2);
            this.cookies = CollectionUtils.unmodifiableMultiValueMap(cookies);
            this.inserter = inserter;
        }

        @Override
        public HttpMethod method() {
            return this.method;
        }

        @Override
        public URI url() {
            return this.url;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public MultiValueMap<String, String> cookies() {
            return this.cookies;
        }

        @Override
        public BodyInserter<?, ? super ClientHttpRequest> body() {
            return this.inserter;
        }

        @Override
        public Mono<Void> writeTo(ClientHttpRequest request, final ExchangeStrategies strategies) {
            HttpHeaders requestHeaders = request.getHeaders();
            if (!this.headers.isEmpty()) {
                this.headers.entrySet().stream().filter(entry -> !requestHeaders.containsKey(entry.getKey())).forEach(entry -> requestHeaders.put((String)entry.getKey(), (List)entry.getValue()));
            }
            MultiValueMap requestCookies = request.getCookies();
            if (!this.cookies.isEmpty()) {
                this.cookies.entrySet().forEach(entry -> {
                    String name = (String)entry.getKey();
                    ((List)entry.getValue()).forEach(value -> {
                        HttpCookie cookie = new HttpCookie(name, value);
                        requestCookies.add((Object)name, (Object)cookie);
                    });
                });
            }
            return this.inserter.insert((ClientHttpRequest)request, new BodyInserter.Context(){

                @Override
                public Supplier<Stream<HttpMessageWriter<?>>> messageWriters() {
                    return strategies.messageWriters();
                }

                @Override
                public Optional<ServerHttpRequest> serverRequest() {
                    return Optional.empty();
                }

                @Override
                public Map<String, Object> hints() {
                    return Collections.emptyMap();
                }
            });
        }
    }
}

