/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.Arrays;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.DefaultWebClient;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeFunctions;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

class DefaultWebClientBuilder
implements WebClient.Builder {
    private String baseUrl;
    private Map<String, ?> defaultUriVariables;
    private UriBuilderFactory uriBuilderFactory;
    private HttpHeaders defaultHeaders;
    private MultiValueMap<String, String> defaultCookies;
    private ClientHttpConnector connector;
    private ExchangeStrategies exchangeStrategies = ExchangeStrategies.withDefaults();
    private ExchangeFunction exchangeFunction;

    DefaultWebClientBuilder() {
    }

    @Override
    public WebClient.Builder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public WebClient.Builder defaultUriVariables(Map<String, ?> defaultUriVariables) {
        this.defaultUriVariables = defaultUriVariables;
        return this;
    }

    @Override
    public WebClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        this.uriBuilderFactory = uriBuilderFactory;
        return this;
    }

    @Override
    public WebClient.Builder defaultHeader(String headerName, String ... headerValues) {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = new HttpHeaders();
        }
        for (String headerValue : headerValues) {
            this.defaultHeaders.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public WebClient.Builder defaultCookie(String cookieName, String ... cookieValues) {
        if (this.defaultCookies == null) {
            this.defaultCookies = new LinkedMultiValueMap(4);
        }
        this.defaultCookies.addAll((Object)cookieName, Arrays.asList(cookieValues));
        return this;
    }

    @Override
    public WebClient.Builder clientConnector(ClientHttpConnector connector) {
        this.connector = connector;
        return this;
    }

    @Override
    public WebClient.Builder exchangeStrategies(ExchangeStrategies strategies) {
        Assert.notNull((Object)strategies, (String)"ExchangeStrategies is required.");
        this.exchangeStrategies = strategies;
        return this;
    }

    @Override
    public WebClient.Builder exchangeFunction(ExchangeFunction exchangeFunction) {
        this.exchangeFunction = exchangeFunction;
        return this;
    }

    @Override
    public WebClient build() {
        return new DefaultWebClient(this.initExchangeFunction(), this.initUriBuilderFactory(), this.defaultHeaders, this.defaultCookies);
    }

    private UriBuilderFactory initUriBuilderFactory() {
        if (this.uriBuilderFactory != null) {
            return this.uriBuilderFactory;
        }
        DefaultUriBuilderFactory factory = this.baseUrl != null ? new DefaultUriBuilderFactory(this.baseUrl) : new DefaultUriBuilderFactory();
        factory.setDefaultUriVariables(this.defaultUriVariables);
        return factory;
    }

    private ExchangeFunction initExchangeFunction() {
        if (this.exchangeFunction != null) {
            return this.exchangeFunction;
        }
        if (this.connector != null) {
            return ExchangeFunctions.create(this.connector, this.exchangeStrategies);
        }
        return ExchangeFunctions.create((ClientHttpConnector)new ReactorClientHttpConnector(), this.exchangeStrategies);
    }
}

