/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.web.reactive.function.client.DefaultExchangeStrategiesBuilder;

public interface ExchangeStrategies {
    public Supplier<Stream<HttpMessageReader<?>>> messageReaders();

    public Supplier<Stream<HttpMessageWriter<?>>> messageWriters();

    public static ExchangeStrategies withDefaults() {
        return ExchangeStrategies.builder().build();
    }

    public static Builder builder() {
        DefaultExchangeStrategiesBuilder builder = new DefaultExchangeStrategiesBuilder();
        builder.defaultConfiguration();
        return builder;
    }

    public static Builder empty() {
        return new DefaultExchangeStrategiesBuilder();
    }

    public static interface Builder {
        public Builder defaultCodecs(Consumer<ClientCodecConfigurer.ClientDefaultCodecsConfigurer> var1);

        public Builder customCodecs(Consumer<CodecConfigurer.CustomCodecsConfigurer> var1);

        public ExchangeStrategies build();
    }
}

