/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultServerRequest
implements ServerRequest {
    private static final Function<UnsupportedMediaTypeException, UnsupportedMediaTypeStatusException> ERROR_MAPPER = ex -> ex.getContentType().map(contentType2 -> new UnsupportedMediaTypeStatusException(contentType2, ex.getSupportedMediaTypes())).orElseGet(() -> new UnsupportedMediaTypeStatusException(ex.getMessage()));
    private final ServerWebExchange exchange;
    private final ServerRequest.Headers headers;
    private final HandlerStrategies strategies;

    DefaultServerRequest(ServerWebExchange exchange, HandlerStrategies strategies) {
        this.exchange = exchange;
        this.strategies = strategies;
        this.headers = new DefaultHeaders();
    }

    @Override
    public HttpMethod method() {
        return this.request().getMethod();
    }

    @Override
    public URI uri() {
        return this.request().getURI();
    }

    @Override
    public ServerRequest.Headers headers() {
        return this.headers;
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor) {
        return this.body(extractor, Collections.emptyMap());
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor, final Map<String, Object> hints) {
        Assert.notNull(extractor, (String)"'extractor' must not be null");
        return extractor.extract((ServerHttpRequest)this.request(), new BodyExtractor.Context(){

            @Override
            public Supplier<Stream<HttpMessageReader<?>>> messageReaders() {
                return DefaultServerRequest.this.strategies.messageReaders();
            }

            @Override
            public Optional<ServerHttpResponse> serverResponse() {
                return Optional.of(DefaultServerRequest.this.exchange().getResponse());
            }

            @Override
            public Map<String, Object> hints() {
                return hints;
            }
        });
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        Mono<? extends T> mono = this.body(BodyExtractors.toMono(elementClass));
        return mono.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER);
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        Flux<? extends T> flux = this.body(BodyExtractors.toFlux(elementClass));
        return flux.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER);
    }

    @Override
    public <T> Optional<T> attribute(String name) {
        return this.exchange.getAttribute(name);
    }

    @Override
    public Map<String, Object> attributes() {
        return this.exchange.getAttributes();
    }

    @Override
    public List<String> queryParams(String name) {
        List<String> queryParams = (List<String>)this.request().getQueryParams().get((Object)name);
        return queryParams != null ? queryParams : Collections.emptyList();
    }

    @Override
    public Map<String, String> pathVariables() {
        return this.exchange.getAttribute(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE).orElseGet(Collections::emptyMap);
    }

    @Override
    public Mono<WebSession> session() {
        return this.exchange.getSession();
    }

    private ServerHttpRequest request() {
        return this.exchange.getRequest();
    }

    ServerWebExchange exchange() {
        return this.exchange;
    }

    public String toString() {
        return String.format("%s %s", this.method(), this.path());
    }

    private class DefaultHeaders
    implements ServerRequest.Headers {
        private DefaultHeaders() {
        }

        private HttpHeaders delegate() {
            return DefaultServerRequest.this.request().getHeaders();
        }

        @Override
        public List<MediaType> accept() {
            return this.delegate().getAccept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.delegate().getAcceptCharset();
        }

        @Override
        public List<Locale.LanguageRange> acceptLanguage() {
            return this.delegate().getAcceptLanguage();
        }

        @Override
        public OptionalLong contentLength() {
            long value = this.delegate().getContentLength();
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.delegate().getContentType());
        }

        @Override
        public InetSocketAddress host() {
            return this.delegate().getHost();
        }

        @Override
        public List<HttpRange> range() {
            return this.delegate().getRange();
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.delegate().get((Object)headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.delegate());
        }

        public String toString() {
            return this.delegate().toString();
        }
    }
}

