/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.server.DefaultHandlerStrategiesBuilder;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.result.view.ViewResolver;

public interface HandlerStrategies {
    public Supplier<Stream<HttpMessageReader<?>>> messageReaders();

    public Supplier<Stream<HttpMessageWriter<?>>> messageWriters();

    public Supplier<Stream<ViewResolver>> viewResolvers();

    public Supplier<Function<ServerRequest, Optional<Locale>>> localeResolver();

    public static HandlerStrategies withDefaults() {
        return HandlerStrategies.builder().build();
    }

    public static Builder builder() {
        DefaultHandlerStrategiesBuilder builder = new DefaultHandlerStrategiesBuilder();
        builder.defaultConfiguration();
        return builder;
    }

    public static Builder empty() {
        return new DefaultHandlerStrategiesBuilder();
    }

    public static interface Builder {
        public Builder defaultCodecs(Consumer<ServerCodecConfigurer.ServerDefaultCodecsConfigurer> var1);

        public Builder customCodecs(Consumer<CodecConfigurer.CustomCodecsConfigurer> var1);

        public Builder viewResolver(ViewResolver var1);

        public Builder localeResolver(Function<ServerRequest, Optional<Locale>> var1);

        public HandlerStrategies build();
    }
}

