/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import org.springframework.web.reactive.function.server.HandlerFilterFunction;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface RouterFunction<T extends ServerResponse> {
    public Mono<HandlerFunction<T>> route(ServerRequest var1);

    default public RouterFunction<T> and(RouterFunction<T> other) {
        return request -> this.route(request).switchIfEmpty(Mono.defer(() -> other.route(request)));
    }

    default public RouterFunction<?> andOther(RouterFunction<?> other) {
        return request -> this.route(request).map(RouterFunctions::cast).switchIfEmpty(Mono.defer(() -> other.route(request).map(RouterFunctions::cast)));
    }

    default public RouterFunction<T> andRoute(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        return this.and(RouterFunctions.route(predicate, handlerFunction));
    }

    default public RouterFunction<T> andNest(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        return this.and(RouterFunctions.nest(predicate, routerFunction));
    }

    default public <S extends ServerResponse> RouterFunction<S> filter(HandlerFilterFunction<T, S> filterFunction) {
        return request -> this.route(request).map(filterFunction::apply);
    }
}

