/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server.support;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerRequestWrapper
implements ServerRequest {
    private final ServerRequest delegate;

    public ServerRequestWrapper(ServerRequest delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    public ServerRequest request() {
        return this.delegate;
    }

    @Override
    public HttpMethod method() {
        return this.delegate.method();
    }

    @Override
    public URI uri() {
        return this.delegate.uri();
    }

    @Override
    public String path() {
        return this.delegate.path();
    }

    @Override
    public ServerRequest.Headers headers() {
        return this.delegate.headers();
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor) {
        return this.delegate.body(extractor);
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor, Map<String, Object> hints) {
        return this.delegate.body(extractor, hints);
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        return this.delegate.bodyToMono(elementClass);
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        return this.delegate.bodyToFlux(elementClass);
    }

    @Override
    public <T> Optional<T> attribute(String name) {
        return this.delegate.attribute(name);
    }

    @Override
    public Map<String, Object> attributes() {
        return this.delegate.attributes();
    }

    @Override
    public Optional<String> queryParam(String name) {
        return this.delegate.queryParam(name);
    }

    @Override
    public List<String> queryParams(String name) {
        return this.delegate.queryParams(name);
    }

    @Override
    public String pathVariable(String name) {
        return this.delegate.pathVariable(name);
    }

    @Override
    public Map<String, String> pathVariables() {
        return this.delegate.pathVariables();
    }

    @Override
    public Mono<WebSession> session() {
        return this.delegate.session();
    }

    public static class HeadersWrapper
    implements ServerRequest.Headers {
        private final ServerRequest.Headers headers;

        public HeadersWrapper(ServerRequest.Headers headers2) {
            Assert.notNull((Object)headers2, (String)"'headers' must not be null");
            this.headers = headers2;
        }

        @Override
        public List<MediaType> accept() {
            return this.headers.accept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.headers.acceptCharset();
        }

        @Override
        public List<Locale.LanguageRange> acceptLanguage() {
            return this.headers.acceptLanguage();
        }

        @Override
        public OptionalLong contentLength() {
            return this.headers.contentLength();
        }

        @Override
        public Optional<MediaType> contentType() {
            return this.headers.contentType();
        }

        @Override
        public InetSocketAddress host() {
            return this.headers.host();
        }

        @Override
        public List<HttpRange> range() {
            return this.headers.range();
        }

        @Override
        public List<String> header(String headerName) {
            return this.headers.header(headerName);
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return this.headers.asHttpHeaders();
        }
    }
}

