/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private boolean useTrailingSlashMatch = false;
    private boolean lazyInitHandlers = false;
    private final Map<String, Object> handlerMap = new LinkedHashMap<String, Object>();

    public void setUseTrailingSlashMatch(boolean useTrailingSlashMatch) {
        this.useTrailingSlashMatch = useTrailingSlashMatch;
    }

    public boolean useTrailingSlashMatch() {
        return this.useTrailingSlashMatch;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    public final Map<String, Object> getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }

    public Mono<Object> getHandlerInternal(ServerWebExchange exchange) {
        Object handler;
        String lookupPath = this.getPathHelper().getLookupPathForRequest(exchange);
        try {
            handler = this.lookupHandler(lookupPath, exchange);
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
        if (handler != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Mapping [" + lookupPath + "] to " + handler));
        } else if (handler == null && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("No handler mapping found for [" + lookupPath + "]"));
        }
        return Mono.justOrEmpty((Object)handler);
    }

    protected Object lookupHandler(String urlPath, ServerWebExchange exchange) throws Exception {
        Object handler = this.handlerMap.get(urlPath);
        if (handler != null) {
            return this.handleMatch(handler, urlPath, urlPath, exchange);
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String pattern : this.handlerMap.keySet()) {
            if (this.getPathMatcher().match(pattern, urlPath)) {
                matches.add(pattern);
                continue;
            }
            if (!this.useTrailingSlashMatch() || pattern.endsWith("/") || !this.getPathMatcher().match(pattern + "/", urlPath)) continue;
            matches.add(pattern + "/");
        }
        String bestMatch = null;
        Comparator comparator = this.getPathMatcher().getPatternComparator(urlPath);
        if (!matches.isEmpty()) {
            Collections.sort(matches, comparator);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Matching patterns for request [" + urlPath + "] are " + matches));
            }
            bestMatch = (String)matches.get(0);
        }
        if (bestMatch != null) {
            handler = this.handlerMap.get(bestMatch);
            if (handler == null) {
                if (bestMatch.endsWith("/")) {
                    handler = this.handlerMap.get(bestMatch.substring(0, bestMatch.length() - 1));
                }
                if (handler == null) {
                    throw new IllegalStateException("Could not find handler for best pattern match [" + bestMatch + "]");
                }
            }
            String pathWithinMapping = this.getPathMatcher().extractPathWithinPattern(bestMatch, urlPath);
            return this.handleMatch(handler, bestMatch, pathWithinMapping, exchange);
        }
        return null;
    }

    private Object handleMatch(Object handler, String bestMatch, String pathWithinMapping, ServerWebExchange exchange) throws Exception {
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.getApplicationContext().getBean(handlerName);
        }
        this.validateHandler(handler, exchange);
        exchange.getAttributes().put(PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, pathWithinMapping);
        exchange.getAttributes().put(BEST_MATCHING_PATTERN_ATTRIBUTE, bestMatch);
        return handler;
    }

    protected void validateHandler(Object handler, ServerWebExchange exchange) throws Exception {
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, (String)"URL path array must not be null");
        for (String urlPath : urlPaths) {
            this.registerHandler(urlPath, (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Object mappedHandler;
        Assert.notNull((Object)urlPath, (String)"URL path must not be null");
        Assert.notNull((Object)handler, (String)"Handler object must not be null");
        Object resolvedHandler = handler;
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                resolvedHandler = this.getApplicationContext().getBean(handlerName);
            }
        }
        if ((mappedHandler = this.handlerMap.get(urlPath)) != null) {
            if (mappedHandler != resolvedHandler) {
                throw new IllegalStateException("Cannot map " + this.getHandlerDescription(handler) + " to URL path [" + urlPath + "]: There is already " + this.getHandlerDescription(mappedHandler) + " mapped.");
            }
        } else {
            this.handlerMap.put(urlPath, resolvedHandler);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Mapped URL path [" + urlPath + "] onto " + this.getHandlerDescription(handler)));
            }
        }
    }

    private String getHandlerDescription(Object handler) {
        return "handler " + (handler instanceof String ? "'" + handler + "'" : "of type [" + handler.getClass() + "]");
    }
}

