/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.Collections;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.ResourceUrlProvider;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class ResourceTransformerSupport
implements ResourceTransformer {
    private ResourceUrlProvider resourceUrlProvider;

    public void setResourceUrlProvider(ResourceUrlProvider resourceUrlProvider) {
        this.resourceUrlProvider = resourceUrlProvider;
    }

    public ResourceUrlProvider getResourceUrlProvider() {
        return this.resourceUrlProvider;
    }

    protected Mono<String> resolveUrlPath(String resourcePath, ServerWebExchange exchange, Resource resource, ResourceTransformerChain transformerChain) {
        if (resourcePath.startsWith("/")) {
            ResourceUrlProvider urlProvider = this.getResourceUrlProvider();
            return urlProvider != null ? urlProvider.getForRequestUrl(exchange, resourcePath) : Mono.empty();
        }
        return transformerChain.getResolverChain().resolveUrlPath(resourcePath, Collections.singletonList(resource));
    }

    protected String toAbsolutePath(String path2, ServerWebExchange exchange) {
        String requestPath = exchange.getRequest().getURI().getPath();
        String absolutePath = StringUtils.applyRelativePath((String)requestPath, (String)path2);
        return StringUtils.cleanPath((String)absolutePath);
    }
}

