/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class TransformedResource
extends ByteArrayResource {
    private final String filename;
    private final long lastModified;

    public TransformedResource(Resource original, byte[] transformedContent) {
        super(transformedContent);
        this.filename = original.getFilename();
        try {
            this.lastModified = original.lastModified();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public long lastModified() {
        return this.lastModified;
    }
}

