/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.SyncInvocableHandlerMethod;
import org.springframework.web.server.ServerWebExchange;

class InitBinderBindingContext
extends BindingContext {
    private final List<SyncInvocableHandlerMethod> binderMethods;
    private final BindingContext binderMethodContext;

    InitBinderBindingContext(WebBindingInitializer initializer, List<SyncInvocableHandlerMethod> binderMethods) {
        super(initializer);
        this.binderMethods = binderMethods;
        this.binderMethodContext = new BindingContext(initializer);
    }

    @Override
    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder dataBinder, ServerWebExchange exchange) {
        this.binderMethods.stream().filter(binderMethod -> {
            InitBinder annotation = (InitBinder)binderMethod.getMethodAnnotation(InitBinder.class);
            List<String> names = Arrays.asList(annotation.value());
            return names.size() == 0 || names.contains(dataBinder.getObjectName());
        }).forEach(method2 -> this.invokeBinderMethod(dataBinder, exchange, (SyncInvocableHandlerMethod)((Object)method2)));
        return dataBinder;
    }

    private void invokeBinderMethod(WebExchangeDataBinder dataBinder, ServerWebExchange exchange, SyncInvocableHandlerMethod binderMethod) {
        Optional<Object> returnValue = binderMethod.invokeForHandlerResult(exchange, this.binderMethodContext, dataBinder).getReturnValue();
        if (returnValue.isPresent()) {
            throw new IllegalStateException("@InitBinder methods should return void: " + (Object)((Object)binderMethod));
        }
        if (!this.binderMethodContext.getModel().asMap().isEmpty()) {
            throw new IllegalStateException("@InitBinder methods should not add model attributes: " + (Object)((Object)binderMethod));
        }
    }
}

