/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class ModelInitializer {
    private final ReactiveAdapterRegistry adapterRegistry;

    public ModelInitializer(ReactiveAdapterRegistry adapterRegistry) {
        this.adapterRegistry = adapterRegistry;
    }

    private ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    public Mono<Void> initModel(BindingContext bindingContext, List<InvocableHandlerMethod> attributeMethods, ServerWebExchange exchange) {
        ArrayList resultList = new ArrayList();
        attributeMethods.forEach(invocable -> resultList.add(invocable.invoke(exchange, bindingContext, new Object[0])));
        return Mono.when(resultList, objectArray -> Arrays.stream(objectArray).map(object -> (HandlerResult)object).map(handlerResult -> this.handleResult((HandlerResult)handlerResult, bindingContext)).collect(Collectors.toList())).flatMap(completionList -> Mono.when((Iterable)completionList));
    }

    private Mono<Void> handleResult(HandlerResult handlerResult, BindingContext bindingContext) {
        return handlerResult.getReturnValue().map(value -> {
            ResolvableType type = handlerResult.getReturnType();
            ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(type.getRawClass(), value);
            if (adapter != null) {
                Class attributeType;
                Class clazz = attributeType = adapter.isNoValue() ? Void.class : type.resolveGeneric(new int[]{0});
                if (attributeType.equals(Void.class)) {
                    return Mono.from((Publisher)adapter.toPublisher(value));
                }
            } else {
                Class attributeType = type.resolve();
            }
            String name = this.getAttributeName(handlerResult.getReturnTypeSource());
            bindingContext.getModel().asMap().putIfAbsent(name, value);
            return Mono.empty();
        }).orElse(Mono.empty());
    }

    private String getAttributeName(MethodParameter param) {
        return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)param.getMethod(), ModelAttribute.class)).filter(ann -> StringUtils.hasText((String)ann.value())).map(ModelAttribute::value).orElse(Conventions.getVariableNameForParameter((MethodParameter)param));
    }
}

