/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class RequestPartMethodArgumentResolver
extends AbstractNamedValueArgumentResolver {
    public RequestPartMethodArgumentResolver(ReactiveAdapterRegistry registry) {
        super(null, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestPart.class);
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestPart ann = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        return ann != null ? new RequestPartNamedValueInfo(ann) : new RequestPartNamedValueInfo();
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter param, ServerWebExchange exchange) {
        Mono partsMono = exchange.getMultipartData().filter(map -> !CollectionUtils.isEmpty((Collection)((Collection)map.get((Object)name)))).map(map -> {
            List parts = (List)map.get((Object)name);
            return parts.size() == 1 ? parts.get(0) : parts;
        });
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(param.getParameterType());
        return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)partsMono)) : partsMono;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter param, ServerWebExchange exchange) {
        String type = param.getNestedParameterType().getSimpleName();
        String reason = "Required " + type + " parameter '" + name + "' is not present";
        throw new ServerWebInputException(reason, param);
    }

    private static class RequestPartNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        RequestPartNamedValueInfo() {
            super("", false, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        RequestPartNamedValueInfo(RequestPart annotation) {
            super(annotation.name(), annotation.required(), "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }
    }
}

