/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Optional;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.web.bind.annotation.SessionAttribute;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class SessionAttributeMethodArgumentResolver
extends AbstractNamedValueArgumentResolver {
    public SessionAttributeMethodArgumentResolver(ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(SessionAttribute.class);
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        SessionAttribute annot = (SessionAttribute)parameter.getParameterAnnotation(SessionAttribute.class);
        return new AbstractNamedValueArgumentResolver.NamedValueInfo(annot.name(), annot.required(), "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
    }

    @Override
    protected Mono<Object> resolveName(String name, MethodParameter parameter, ServerWebExchange exchange) {
        return exchange.getSession().map(session -> session.getAttribute(name)).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        String type = parameter.getNestedParameterType().getSimpleName();
        String reason = "Missing session attribute '" + name + "' of type " + type;
        throw new ServerWebInputException(reason, parameter);
    }
}

