/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.reactive.result.view.Rendering;

class DefaultRendering
implements Rendering {
    private static final HttpHeaders EMPTY_HEADERS = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)new HttpHeaders());
    private final Object view;
    private final Map<String, Object> model;
    private final HttpStatus status;
    private final HttpHeaders headers;

    DefaultRendering(Object view, Model model, HttpStatus status, HttpHeaders headers2) {
        this.view = view;
        this.model = model != null ? model.asMap() : Collections.emptyMap();
        this.status = status;
        this.headers = headers2 != null ? headers2 : EMPTY_HEADERS;
    }

    @Override
    public Optional<Object> view() {
        return Optional.ofNullable(this.view);
    }

    @Override
    public Map<String, Object> modelAttributes() {
        return this.model;
    }

    @Override
    public Optional<HttpStatus> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    public String toString() {
        return "Rendering[view=" + this.view + ", modelAttributes=" + this.model + ", status=" + this.status + ", headers=" + this.headers + "]";
    }
}

