/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.result.view.DefaultRenderingBuilder;
import org.springframework.web.reactive.result.view.RedirectView;

public interface Rendering {
    public Optional<Object> view();

    public Map<String, Object> modelAttributes();

    public Optional<HttpStatus> status();

    public HttpHeaders headers();

    public static Builder<?> view(String name) {
        return new DefaultRenderingBuilder(name);
    }

    public static RedirectBuilder redirectTo(String url) {
        return new DefaultRenderingBuilder(new RedirectView(url));
    }

    public static interface RedirectBuilder
    extends Builder<RedirectBuilder> {
        public RedirectBuilder contextRelative(boolean var1);

        public RedirectBuilder propagateQuery(boolean var1);
    }

    public static interface Builder<B extends Builder<B>> {
        public B modelAttribute(String var1, Object var2);

        public B modelAttribute(Object var1);

        public B modelAttributes(Object ... var1);

        public B model(Map<String, ?> var1);

        public B status(HttpStatus var1);

        public B header(String var1, String ... var2);

        public B headers(HttpHeaders var1);

        public Rendering build();
    }
}

