/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

public abstract class ViewResolverSupport
implements ApplicationContextAware,
Ordered {
    public static final MediaType DEFAULT_CONTENT_TYPE = MediaType.parseMediaType((String)"text/html;charset=UTF-8");
    private List<MediaType> mediaTypes = new ArrayList<MediaType>(4);
    private Charset defaultCharset = StandardCharsets.UTF_8;
    private ApplicationContext applicationContext;
    private int order = Integer.MAX_VALUE;

    public ViewResolverSupport() {
        this.mediaTypes.add(DEFAULT_CONTENT_TYPE);
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, (String)"MediaType List must not be empty");
        this.mediaTypes.clear();
        if (supportedMediaTypes != null) {
            this.mediaTypes.addAll(supportedMediaTypes);
        }
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypes;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        Assert.notNull((Object)defaultCharset, (String)"Default Charset must not be null");
        this.defaultCharset = defaultCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

