/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfig;

public class FreeMarkerConfigurer
extends FreeMarkerConfigurationFactory
implements FreeMarkerConfig,
InitializingBean,
ResourceLoaderAware {
    private Configuration configuration;

    public FreeMarkerConfigurer() {
        this.setDefaultEncoding("UTF-8");
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws IOException, TemplateException {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
    }

    protected void postProcessTemplateLoaders(List<TemplateLoader> templateLoaders) {
        templateLoaders.add((TemplateLoader)new ClassTemplateLoader(FreeMarkerConfigurer.class, ""));
        this.logger.info((Object)"ClassTemplateLoader for Spring macros added to FreeMarker configuration");
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

