/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.handler.PathMatchResult;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternComparator;
import org.springframework.web.util.pattern.PathPatternParser;

public class PathPatternRegistry<T> {
    private final PathPatternParser pathPatternParser;
    private final Map<PathPattern, T> patternsMap;

    public PathPatternRegistry() {
        this(new PathPatternParser());
    }

    public PathPatternRegistry(PathPatternParser patternParser) {
        this(patternParser, Collections.emptyMap());
    }

    public PathPatternRegistry(PathPatternParser patternParser, Map<PathPattern, T> patternsMap) {
        this.pathPatternParser = patternParser;
        this.patternsMap = new HashMap<PathPattern, T>(patternsMap);
    }

    public Map<PathPattern, T> getPatternsMap() {
        return Collections.unmodifiableMap(this.patternsMap);
    }

    public SortedSet<PathMatchResult<T>> findMatches(String lookupPath) {
        return this.patternsMap.entrySet().stream().filter(entry -> ((PathPattern)entry.getKey()).matches(lookupPath)).map(entry -> new PathMatchResult((PathPattern)entry.getKey(), entry.getValue())).collect(Collectors.toCollection(() -> new TreeSet(new PathMatchResultComparator(lookupPath))));
    }

    public Optional<PathMatchResult<T>> findFirstMatch(String lookupPath) {
        PathPatternComparator comparator = new PathPatternComparator(lookupPath);
        return this.patternsMap.entrySet().stream().filter(entry -> ((PathPattern)entry.getKey()).matches(lookupPath)).reduce((e1, e2) -> comparator.compare((PathPattern)e1.getKey(), (PathPattern)e2.getKey()) < 0 ? e1 : e2).map(entry -> new PathMatchResult((PathPattern)entry.getKey(), entry.getValue()));
    }

    public void clear() {
        this.patternsMap.clear();
    }

    public void register(String rawPattern, T handler) {
        String fixedPattern = this.prependLeadingSlash(rawPattern);
        PathPattern newPattern = this.pathPatternParser.parse(fixedPattern);
        this.patternsMap.put(newPattern, handler);
    }

    private String prependLeadingSlash(String pattern) {
        if (StringUtils.hasLength((String)pattern) && !pattern.startsWith("/")) {
            return "/" + pattern;
        }
        return pattern;
    }

    private class PathMatchResultComparator<T>
    implements Comparator<PathMatchResult<T>> {
        private final String path;

        public PathMatchResultComparator(String path2) {
            this.path = path2;
        }

        @Override
        public int compare(PathMatchResult<T> o1, PathMatchResult<T> o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            PathPattern p1 = o1.getPattern();
            PathPattern p2 = o2.getPattern();
            if (p1.getPatternString().equals(this.path)) {
                return p2.getPatternString().equals(this.path) ? 0 : -1;
            }
            if (p2.getPatternString().equals(this.path)) {
                return 1;
            }
            int result = p1.compareTo(p2);
            if (result == 0) {
                return p1.getPatternString().compareTo(p2.getPatternString());
            }
            return result;
        }
    }
}

