/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.HandlerResultHandlerSupport;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageWriterResultHandler
extends HandlerResultHandlerSupport {
    private final List<HttpMessageWriter<?>> messageWriters;

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        this(messageWriters, contentTypeResolver, new ReactiveAdapterRegistry());
    }

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        Assert.notEmpty(messageWriters, (String)"At least one message writer is required");
        this.messageWriters = messageWriters;
    }

    public List<HttpMessageWriter<?>> getMessageWriters() {
        return this.messageWriters;
    }

    protected Mono<Void> writeBody(@Nullable Object body, MethodParameter bodyParameter, ServerWebExchange exchange) {
        ResolvableType elementType;
        Mono publisher;
        ResolvableType bodyType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter);
        Class bodyClass = bodyType.resolve();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(bodyClass, body);
        if (adapter != null) {
            publisher = adapter.toPublisher(body);
            elementType = adapter.isNoValue() ? ResolvableType.forClass(Void.class) : bodyType.getGeneric(new int[]{0});
        } else {
            publisher = Mono.justOrEmpty((Object)body);
            ResolvableType resolvableType = elementType = bodyClass == null && body != null ? ResolvableType.forInstance((Object)body) : bodyType;
        }
        if (Void.TYPE == elementType.getRawClass() || Void.class == elementType.getRawClass()) {
            return Mono.from((Publisher)publisher);
        }
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        MediaType bestMediaType = this.selectMediaType(exchange, () -> this.getProducibleMediaTypes(elementType));
        if (bestMediaType != null) {
            for (HttpMessageWriter<?> writer : this.getMessageWriters()) {
                if (!writer.canWrite(elementType, bestMediaType)) continue;
                return writer.write((Publisher)publisher, bodyType, elementType, bestMediaType, request, response, Collections.emptyMap());
            }
        } else if (this.getProducibleMediaTypes(elementType).isEmpty()) {
            return Mono.error((Throwable)new IllegalStateException("No converter for return value type: " + elementType));
        }
        return Mono.error((Throwable)new NotAcceptableStatusException(this.getProducibleMediaTypes(elementType)));
    }

    private List<MediaType> getProducibleMediaTypes(ResolvableType elementType) {
        return this.getMessageWriters().stream().filter(converter -> converter.canWrite(elementType, null)).flatMap(converter -> converter.getWritableMediaTypes().stream()).collect(Collectors.toList());
    }
}

