/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageWriterResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponseEntityResultHandler
extends AbstractMessageWriterResultHandler
implements HandlerResultHandler {
    private static final List<HttpMethod> SAFE_METHODS = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD);

    public ResponseEntityResultHandler(List<HttpMessageWriter<?>> writers, RequestedContentTypeResolver resolver) {
        this(writers, resolver, new ReactiveAdapterRegistry());
    }

    public ResponseEntityResultHandler(List<HttpMessageWriter<?>> writers, RequestedContentTypeResolver resolver, ReactiveAdapterRegistry registry) {
        super(writers, resolver, registry);
        this.setOrder(0);
    }

    @Override
    public boolean supports(HandlerResult result) {
        if (this.isSupportedType(result.getReturnType().getRawClass())) {
            return true;
        }
        ReactiveAdapter adapter = this.getAdapter(result);
        return adapter != null && !adapter.isNoValue() && this.isSupportedType(result.getReturnType().getGeneric(new int[0]).resolve(Object.class));
    }

    private boolean isSupportedType(@Nullable Class<?> clazz) {
        return clazz != null && HttpEntity.class.isAssignableFrom(clazz) && !RequestEntity.class.isAssignableFrom(clazz);
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        MethodParameter bodyParameter;
        Mono returnValueMono;
        ReactiveAdapter adapter = this.getAdapter(result);
        if (adapter != null) {
            Assert.isTrue((!adapter.isMultiValue() ? 1 : 0) != 0, (String)"Only a single ResponseEntity supported");
            returnValueMono = Mono.from((Publisher)adapter.toPublisher(result.getReturnValue()));
            bodyParameter = result.getReturnTypeSource().nested().nested();
        } else {
            returnValueMono = Mono.justOrEmpty((Object)result.getReturnValue());
            bodyParameter = result.getReturnTypeSource().nested();
        }
        return returnValueMono.flatMap(returnValue -> {
            Assert.isInstanceOf(HttpEntity.class, (Object)returnValue, (String)"HttpEntity expected");
            HttpEntity httpEntity = (HttpEntity)returnValue;
            if (httpEntity instanceof ResponseEntity) {
                ResponseEntity responseEntity = (ResponseEntity)httpEntity;
                exchange.getResponse().setStatusCode(responseEntity.getStatusCode());
            }
            HttpHeaders entityHeaders = httpEntity.getHeaders();
            HttpHeaders responseHeaders = exchange.getResponse().getHeaders();
            if (!entityHeaders.isEmpty()) {
                entityHeaders.entrySet().stream().filter(entry -> !responseHeaders.containsKey(entry.getKey())).forEach(entry -> responseHeaders.put((String)entry.getKey(), (List)entry.getValue()));
            }
            if (httpEntity.getBody() == null) {
                return exchange.getResponse().setComplete();
            }
            String etag = entityHeaders.getETag();
            Instant lastModified = Instant.ofEpochMilli(entityHeaders.getLastModified());
            HttpMethod httpMethod = exchange.getRequest().getMethod();
            if (SAFE_METHODS.contains(httpMethod) && exchange.checkNotModified(etag, lastModified)) {
                return exchange.getResponse().setComplete();
            }
            return this.writeBody(httpEntity.getBody(), bodyParameter, exchange);
        });
    }
}

