/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.reactive.result.view.RequestDataValueProcessor;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;
import reactor.core.publisher.Mono;

public class RedirectView
extends AbstractUrlBasedView {
    private static final Pattern URI_TEMPLATE_VARIABLE_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private boolean contextRelative = true;
    private HttpStatus statusCode = HttpStatus.SEE_OTHER;
    private boolean propagateQuery = false;
    private String[] hosts;

    public RedirectView() {
    }

    public RedirectView(String redirectUrl) {
        super(redirectUrl);
    }

    public RedirectView(String redirectUrl, HttpStatus statusCode) {
        super(redirectUrl);
        this.setStatusCode(statusCode);
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public void setStatusCode(HttpStatus statusCode) {
        Assert.notNull((Object)statusCode, (String)"HttpStatus must not be null");
        Assert.isTrue((boolean)statusCode.is3xxRedirection(), (String)"Must be a redirection (3xx status code)");
        this.statusCode = statusCode;
    }

    @Nullable
    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public void setPropagateQuery(boolean propagateQuery) {
        this.propagateQuery = propagateQuery;
    }

    public boolean isPropagateQuery() {
        return this.propagateQuery;
    }

    public void setHosts(String ... hosts) {
        this.hosts = hosts;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.getStatusCode() == null) {
            throw new IllegalArgumentException("Property 'statusCode' is required");
        }
    }

    @Override
    public boolean isRedirectView() {
        return true;
    }

    @Override
    public boolean checkResourceExists(Locale locale) throws Exception {
        return true;
    }

    @Override
    protected Mono<Void> renderInternal(Map<String, Object> model, MediaType contentType2, ServerWebExchange exchange) {
        String targetUrl = this.createTargetUrl(model, exchange);
        return this.sendRedirect(targetUrl, exchange);
    }

    protected final String createTargetUrl(Map<String, Object> model, ServerWebExchange exchange) {
        String url = this.getUrl();
        Assert.state((url != null ? 1 : 0) != 0, (String)"'url' not set");
        ServerHttpRequest request = exchange.getRequest();
        StringBuilder targetUrl = new StringBuilder();
        if (this.isContextRelative() && url.startsWith("/")) {
            targetUrl.append(request.getPath().contextPath().value());
        }
        targetUrl.append(url);
        if (StringUtils.hasText((CharSequence)targetUrl)) {
            Map<String, String> uriVars = this.getCurrentUriVariables(exchange);
            targetUrl = this.expandTargetUrlTemplate(targetUrl.toString(), model, uriVars);
        }
        if (this.isPropagateQuery()) {
            targetUrl = this.appendCurrentRequestQuery(targetUrl.toString(), request);
        }
        String result = targetUrl.toString();
        RequestDataValueProcessor processor = this.getRequestDataValueProcessor();
        return processor != null ? processor.processUrl(exchange, result) : result;
    }

    private Map<String, String> getCurrentUriVariables(ServerWebExchange exchange) {
        String name = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        return exchange.getAttribute(name).orElse(Collections.emptyMap());
    }

    protected StringBuilder expandTargetUrlTemplate(String targetUrl, Map<String, Object> model, Map<String, String> uriVariables) {
        Matcher matcher = URI_TEMPLATE_VARIABLE_PATTERN.matcher(targetUrl);
        boolean found = matcher.find();
        if (!found) {
            return new StringBuilder(targetUrl);
        }
        StringBuilder result = new StringBuilder();
        int endLastMatch = 0;
        while (found) {
            String name = matcher.group(1);
            Object value = model.containsKey(name) ? model.get(name) : uriVariables.get(name);
            Assert.notNull((Object)value, (String)("No value for URI variable '" + name + "'"));
            result.append(targetUrl.substring(endLastMatch, matcher.start()));
            result.append(this.encodeUriVariable(value.toString()));
            endLastMatch = matcher.end();
            found = matcher.find();
        }
        result.append(targetUrl.substring(endLastMatch, targetUrl.length()));
        return result;
    }

    private String encodeUriVariable(String text) {
        return UriUtils.encode((String)text, (Charset)StandardCharsets.UTF_8);
    }

    protected StringBuilder appendCurrentRequestQuery(String targetUrl, ServerHttpRequest request) {
        String query = request.getURI().getRawQuery();
        if (!StringUtils.hasText((String)query)) {
            return new StringBuilder(targetUrl);
        }
        int index = targetUrl.indexOf("#");
        String fragment = index > -1 ? targetUrl.substring(index) : null;
        StringBuilder result = new StringBuilder();
        result.append(index != -1 ? targetUrl.substring(0, index) : targetUrl);
        result.append(targetUrl.indexOf(63) < 0 ? (char)'?' : '&').append(query);
        if (fragment != null) {
            result.append(fragment);
        }
        return result;
    }

    protected Mono<Void> sendRedirect(String targetUrl, ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        String encodedURL = this.isRemoteHost(targetUrl) ? targetUrl : response.encodeUrl(targetUrl);
        response.getHeaders().setLocation(URI.create(encodedURL));
        HttpStatus status = this.getStatusCode();
        if (status != null) {
            response.setStatusCode(status);
        }
        return Mono.empty();
    }

    protected boolean isRemoteHost(String targetUrl) {
        if (ObjectUtils.isEmpty((Object[])this.hosts)) {
            return false;
        }
        String targetHost = UriComponentsBuilder.fromUriString((String)targetUrl).build().getHost();
        if (StringUtils.isEmpty((Object)targetHost)) {
            return false;
        }
        for (String host : this.hosts) {
            if (!targetHost.equals(host)) continue;
            return false;
        }
        return true;
    }
}

