/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClientSupport;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.XnioWorker;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class UndertowWebSocketClient
extends WebSocketClientSupport
implements WebSocketClient {
    private static final int DEFAULT_POOL_BUFFER_SIZE = 8192;
    private final XnioWorker worker;
    private final Consumer<WebSocketClient.ConnectionBuilder> builderConsumer;
    private int poolBufferSize = 8192;
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public UndertowWebSocketClient(XnioWorker worker) {
        this(worker, builder -> {});
    }

    public UndertowWebSocketClient(XnioWorker worker, Consumer<WebSocketClient.ConnectionBuilder> builderConsumer) {
        Assert.notNull((Object)worker, (String)"XnioWorker is required");
        this.worker = worker;
        this.builderConsumer = builderConsumer;
    }

    public XnioWorker getXnioWorker() {
        return this.worker;
    }

    public Consumer<WebSocketClient.ConnectionBuilder> getConnectionBuilderConsumer() {
        return this.builderConsumer;
    }

    public void setPoolBufferSize(int poolBufferSize) {
        this.poolBufferSize = poolBufferSize;
    }

    public int getPoolBufferSize() {
        return this.poolBufferSize;
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders headers2, WebSocketHandler handler) {
        return this.executeInternal(url, headers2, handler);
    }

    private Mono<Void> executeInternal(final URI url, HttpHeaders headers2, final WebSocketHandler handler) {
        final MonoProcessor completion = MonoProcessor.create();
        return Mono.fromCallable(() -> {
            WebSocketClient.ConnectionBuilder builder = this.createConnectionBuilder(url);
            List<String> protocols = this.beforeHandshake(url, headers2, handler);
            final DefaultNegotiation negotiation = new DefaultNegotiation(protocols, headers2, builder);
            builder.setClientNegotiation((WebSocketClientNegotiation)negotiation);
            return builder.connect().addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<WebSocketChannel, Object>(){

                public void handleDone(WebSocketChannel channel, Object attachment) {
                    UndertowWebSocketClient.this.handleChannel(url, handler, (MonoProcessor<Void>)completion, negotiation, channel);
                }

                public void handleFailed(IOException ex, Object attachment) {
                    completion.onError((Throwable)new IllegalStateException("Failed to connect", ex));
                }
            }, null);
        }).then((Mono)completion);
    }

    protected WebSocketClient.ConnectionBuilder createConnectionBuilder(URI url) {
        WebSocketClient.ConnectionBuilder builder = io.undertow.websockets.client.WebSocketClient.connectionBuilder((XnioWorker)this.getXnioWorker(), (ByteBufferPool)new DefaultByteBufferPool(false, this.getPoolBufferSize()), (URI)url);
        this.builderConsumer.accept(builder);
        return builder;
    }

    private void handleChannel(URI url, WebSocketHandler handler, MonoProcessor<Void> completion, DefaultNegotiation negotiation, WebSocketChannel channel) {
        HandshakeInfo info = this.afterHandshake(url, negotiation.getResponseHeaders());
        UndertowWebSocketSession session = new UndertowWebSocketSession(channel, info, this.bufferFactory, completion);
        UndertowWebSocketHandlerAdapter adapter = new UndertowWebSocketHandlerAdapter(session);
        channel.getReceiveSetter().set((ChannelListener)adapter);
        channel.resumeReceives();
        handler.handle(session).subscribe((Subscriber)session);
    }

    private static final class DefaultNegotiation
    extends WebSocketClientNegotiation {
        private final HttpHeaders requestHeaders;
        private final HttpHeaders responseHeaders = new HttpHeaders();
        private final WebSocketClientNegotiation delegate;

        public DefaultNegotiation(List<String> protocols, HttpHeaders requestHeaders, WebSocketClient.ConnectionBuilder connectionBuilder) {
            super(protocols, Collections.emptyList());
            this.requestHeaders = requestHeaders;
            this.delegate = connectionBuilder.getClientNegotiation();
        }

        public HttpHeaders getResponseHeaders() {
            return this.responseHeaders;
        }

        public void beforeRequest(Map<String, List<String>> headers2) {
            this.requestHeaders.forEach(headers2::put);
            if (this.delegate != null) {
                this.delegate.beforeRequest(headers2);
            }
        }

        public void afterRequest(Map<String, List<String>> headers2) {
            headers2.forEach((arg_0, arg_1) -> ((HttpHeaders)this.responseHeaders).put(arg_0, arg_1));
            if (this.delegate != null) {
                this.delegate.afterRequest(headers2);
            }
        }
    }
}

