/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Mono<Object[]> EMPTY_ARGS = Mono.just((Object)new Object[0]);
    private static final Object NO_ARG_VALUE = new Object();
    private List<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private ReactiveAdapterRegistry reactiveAdapterRegistry = new ReactiveAdapterRegistry();

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean, Method method2) {
        super(bean, method2);
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        this.resolvers.clear();
        this.resolvers.addAll(resolvers);
    }

    public List<HandlerMethodArgumentResolver> getResolvers() {
        return this.resolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer nameDiscoverer) {
        this.parameterNameDiscoverer = nameDiscoverer;
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    public Mono<HandlerResult> invoke(ServerWebExchange exchange, BindingContext bindingContext, Object ... providedArgs) {
        return this.resolveArguments(exchange, bindingContext, providedArgs).flatMap(args -> {
            try {
                Object value = this.doInvoke((Object[])args);
                HttpStatus status = this.getResponseStatus();
                if (status != null) {
                    exchange.getResponse().setStatusCode(status);
                }
                MethodParameter returnType = this.getReturnType();
                ReactiveAdapter adapter = this.reactiveAdapterRegistry.getAdapter(returnType.getParameterType());
                boolean asyncVoid = this.isAsyncVoidReturnType(returnType, adapter);
                if ((value == null || asyncVoid) && this.isResponseHandled((Object[])args, exchange)) {
                    this.logger.debug((Object)"Response fully handled in controller method");
                    return asyncVoid ? Mono.from((Publisher)adapter.toPublisher(value)) : Mono.empty();
                }
                HandlerResult result = new HandlerResult((Object)this, value, returnType, bindingContext);
                return Mono.just((Object)result);
            }
            catch (InvocationTargetException ex) {
                return Mono.error((Throwable)ex.getTargetException());
            }
            catch (Throwable ex) {
                return Mono.error((Throwable)new IllegalStateException(this.getInvocationErrorMessage((Object[])args)));
            }
        });
    }

    private Mono<Object[]> resolveArguments(ServerWebExchange exchange, BindingContext bindingContext, Object ... providedArgs) {
        if (ObjectUtils.isEmpty((Object[])this.getMethodParameters())) {
            return EMPTY_ARGS;
        }
        try {
            List argMonos = Stream.of(this.getMethodParameters()).map(param -> {
                param.initParameterNameDiscovery(this.parameterNameDiscoverer);
                return this.findProvidedArgument((MethodParameter)param, providedArgs).map(Mono::just).orElseGet(() -> {
                    HandlerMethodArgumentResolver resolver = this.findResolver((MethodParameter)param);
                    return this.resolveArg(resolver, (MethodParameter)param, bindingContext, exchange);
                });
            }).collect(Collectors.toList());
            return Mono.zip(argMonos, argValues -> Stream.of(argValues).map(o -> o != NO_ARG_VALUE ? o : null).toArray());
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
    }

    private Optional<Object> findProvidedArgument(MethodParameter parameter, Object ... providedArgs) {
        if (ObjectUtils.isEmpty((Object[])providedArgs)) {
            return Optional.empty();
        }
        return Arrays.stream(providedArgs).filter(arg -> parameter.getParameterType().isInstance(arg)).findFirst();
    }

    private HandlerMethodArgumentResolver findResolver(MethodParameter param) {
        return this.resolvers.stream().filter(r -> r.supportsParameter(param)).findFirst().orElseThrow(() -> this.getArgumentError("No suitable resolver for", param, null));
    }

    private Mono<Object> resolveArg(HandlerMethodArgumentResolver resolver, MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        try {
            return resolver.resolveArgument(parameter, bindingContext, exchange).defaultIfEmpty(NO_ARG_VALUE).doOnError(cause -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.getDetailedErrorMessage("Failed to resolve", parameter), cause);
                }
            });
        }
        catch (Exception ex) {
            throw this.getArgumentError("Failed to resolve", parameter, ex);
        }
    }

    private IllegalStateException getArgumentError(String text, MethodParameter parameter, @Nullable Throwable ex) {
        return new IllegalStateException(this.getDetailedErrorMessage(text, parameter), ex);
    }

    private String getDetailedErrorMessage(String text, MethodParameter param) {
        return text + " argument " + param.getParameterIndex() + " of type '" + param.getParameterType().getName() + "' on " + this.getBridgedMethod().toGenericString();
    }

    @Nullable
    private Object doInvoke(Object[] args) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking '" + ClassUtils.getQualifiedMethodName((Method)this.getMethod(), (Class)this.getBeanType()) + "' with arguments " + Arrays.toString(args)));
        }
        ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
        Object returnValue = this.getBridgedMethod().invoke(this.getBean(), args);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Method [" + ClassUtils.getQualifiedMethodName((Method)this.getMethod(), (Class)this.getBeanType()) + "] returned [" + returnValue + "]"));
        }
        return returnValue;
    }

    private String getInvocationErrorMessage(Object[] args) {
        String argumentDetails = IntStream.range(0, args.length).mapToObj(i -> args[i] != null ? "[" + i + "][type=" + args[i].getClass().getName() + "][value=" + args[i] + "]" : "[" + i + "][null]").collect(Collectors.joining(",", " ", " "));
        return "Failed to invoke handler method with resolved arguments:" + argumentDetails + "on " + this.getBridgedMethod().toGenericString();
    }

    private boolean isAsyncVoidReturnType(MethodParameter returnType, @Nullable ReactiveAdapter reactiveAdapter) {
        if (reactiveAdapter != null && reactiveAdapter.supportsEmpty()) {
            ParameterizedType type;
            if (reactiveAdapter.isNoValue()) {
                return true;
            }
            Type parameterType = returnType.getGenericParameterType();
            if (parameterType instanceof ParameterizedType && (type = (ParameterizedType)parameterType).getActualTypeArguments().length == 1) {
                return Void.class.equals((Object)type.getActualTypeArguments()[0]);
            }
        }
        return false;
    }

    private boolean isResponseHandled(Object[] args, ServerWebExchange exchange) {
        if (this.getResponseStatus() != null || exchange.isNotModified()) {
            return true;
        }
        for (Object arg : args) {
            if (!(arg instanceof ServerHttpResponse) && !(arg instanceof ServerWebExchange)) continue;
            return true;
        }
        return false;
    }
}

