/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import io.micrometer.observation.transport.RequestReplySenderContext;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public class ClientRequestObservationContext
extends RequestReplySenderContext<ClientRequest.Builder, ClientResponse> {
    public static final String CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE = ClientRequestObservationContext.class.getName();
    @Nullable
    private String uriTemplate;
    private boolean aborted;
    @Nullable
    private ClientRequest request;

    @Deprecated(since="6.1", forRemoval=true)
    public ClientRequestObservationContext() {
        super(ClientRequestObservationContext::setRequestHeader);
    }

    public ClientRequestObservationContext(ClientRequest.Builder request) {
        super(ClientRequestObservationContext::setRequestHeader);
        this.setCarrier(request);
        this.setRequest(request.build());
    }

    private static void setRequestHeader(@Nullable ClientRequest.Builder request, String name, String value) {
        if (request != null) {
            request.headers(headers -> headers.set(name, value));
        }
    }

    @Nullable
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(@Nullable String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    @Nullable
    public ClientRequest getRequest() {
        return this.request;
    }

    public void setRequest(ClientRequest request) {
        this.request = request;
    }

    public static Optional<ClientRequestObservationContext> findCurrent(ClientRequest request) {
        return Optional.ofNullable((ClientRequestObservationContext)((Object)request.attributes().get(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE)));
    }
}

