/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.security.Principal;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class PrincipalMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    public PrincipalMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkParameterType(parameter, Principal.class::isAssignableFrom);
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange2) {
        Mono principal = exchange2.getPrincipal();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(parameter.getParameterType());
        return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)principal)) : Mono.from((Publisher)principal);
    }
}

