/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.method.MethodValidationException;
import org.springframework.web.ErrorResponse;
import org.springframework.web.ErrorResponseException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.method.annotation.HandlerMethodValidationException;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.MissingRequestValueException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsatisfiedRequestParameterException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Mono;

public abstract class ResponseEntityExceptionHandler
implements MessageSourceAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private @Nullable MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected @Nullable MessageSource getMessageSource() {
        return this.messageSource;
    }

    @ExceptionHandler(value={MethodNotAllowedException.class, NotAcceptableStatusException.class, UnsupportedMediaTypeStatusException.class, MissingRequestValueException.class, UnsatisfiedRequestParameterException.class, WebExchangeBindException.class, HandlerMethodValidationException.class, ServerWebInputException.class, ServerErrorException.class, ResponseStatusException.class, ErrorResponseException.class, MethodValidationException.class})
    public final Mono<ResponseEntity<Object>> handleException(Exception ex, ServerWebExchange exchange2) {
        if (ex instanceof MethodNotAllowedException) {
            MethodNotAllowedException theEx = (MethodNotAllowedException)ex;
            return this.handleMethodNotAllowedException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof NotAcceptableStatusException) {
            NotAcceptableStatusException theEx = (NotAcceptableStatusException)((Object)ex);
            return this.handleNotAcceptableStatusException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof UnsupportedMediaTypeStatusException) {
            UnsupportedMediaTypeStatusException theEx = (UnsupportedMediaTypeStatusException)ex;
            return this.handleUnsupportedMediaTypeStatusException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof MissingRequestValueException) {
            MissingRequestValueException theEx = (MissingRequestValueException)ex;
            return this.handleMissingRequestValueException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof UnsatisfiedRequestParameterException) {
            UnsatisfiedRequestParameterException theEx = (UnsatisfiedRequestParameterException)ex;
            return this.handleUnsatisfiedRequestParameterException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof WebExchangeBindException) {
            WebExchangeBindException theEx = (WebExchangeBindException)ex;
            return this.handleWebExchangeBindException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof HandlerMethodValidationException) {
            HandlerMethodValidationException theEx = (HandlerMethodValidationException)ex;
            return this.handleHandlerMethodValidationException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof ServerWebInputException) {
            ServerWebInputException theEx = (ServerWebInputException)ex;
            return this.handleServerWebInputException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof ServerErrorException) {
            ServerErrorException theEx = (ServerErrorException)ex;
            return this.handleServerErrorException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof ResponseStatusException) {
            ResponseStatusException theEx = (ResponseStatusException)ex;
            return this.handleResponseStatusException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof ErrorResponseException) {
            ErrorResponseException theEx = (ErrorResponseException)ex;
            return this.handleErrorResponseException(theEx, theEx.getHeaders(), theEx.getStatusCode(), exchange2);
        }
        if (ex instanceof MethodValidationException) {
            MethodValidationException theEx = (MethodValidationException)ex;
            return this.handleMethodValidationException(theEx, HttpStatus.INTERNAL_SERVER_ERROR, exchange2);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Unexpected exception type: " + ex.getClass().getName()));
        }
        return Mono.error((Throwable)ex);
    }

    protected Mono<ResponseEntity<Object>> handleMethodNotAllowedException(MethodNotAllowedException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleNotAcceptableStatusException(NotAcceptableStatusException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleUnsupportedMediaTypeStatusException(UnsupportedMediaTypeStatusException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleMissingRequestValueException(MissingRequestValueException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleUnsatisfiedRequestParameterException(UnsatisfiedRequestParameterException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleWebExchangeBindException(WebExchangeBindException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleHandlerMethodValidationException(HandlerMethodValidationException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleServerWebInputException(ServerWebInputException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleResponseStatusException(ResponseStatusException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleServerErrorException(ServerErrorException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleErrorResponseException(ErrorResponseException ex, HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> handleMethodValidationException(MethodValidationException ex, HttpStatus status, ServerWebExchange exchange2) {
        ProblemDetail body2 = this.createProblemDetail((Exception)ex, (HttpStatusCode)status, "Validation failed", null, null, exchange2);
        return this.handleExceptionInternal((Exception)ex, body2, null, (HttpStatusCode)status, exchange2);
    }

    protected ProblemDetail createProblemDetail(Exception ex, HttpStatusCode status, String defaultDetail, @Nullable String detailMessageCode, Object @Nullable [] detailMessageArguments, ServerWebExchange exchange2) {
        ErrorResponse.Builder builder = ErrorResponse.builder((Throwable)ex, (HttpStatusCode)status, (String)defaultDetail);
        if (detailMessageCode != null) {
            builder.detailMessageCode(detailMessageCode);
        }
        if (detailMessageArguments != null) {
            builder.detailMessageArguments(detailMessageArguments);
        }
        return builder.build().updateAndGetBody(this.messageSource, ResponseEntityExceptionHandler.getLocale(exchange2));
    }

    private static Locale getLocale(ServerWebExchange exchange2) {
        Locale locale = exchange2.getLocaleContext().getLocale();
        return locale != null ? locale : Locale.getDefault();
    }

    protected Mono<ResponseEntity<Object>> handleExceptionInternal(Exception ex, @Nullable Object body2, @Nullable HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        if (exchange2.getResponse().isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        if (body2 == null && ex instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)ex;
            body2 = errorResponse.updateAndGetBody(this.messageSource, ResponseEntityExceptionHandler.getLocale(exchange2));
        }
        return this.createResponseEntity(body2, headers, status, exchange2);
    }

    protected Mono<ResponseEntity<Object>> createResponseEntity(@Nullable Object body2, @Nullable HttpHeaders headers, HttpStatusCode status, ServerWebExchange exchange2) {
        return Mono.just((Object)new ResponseEntity(body2, headers, status));
    }
}

