/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.beans.PropertyEditor;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;

public class BindTag
extends HtmlEscapingAwareTag {
    public static final String STATUS_VARIABLE_NAME = "status";
    private String path;
    private boolean ignoreNestedPath = false;
    private BindStatus status;
    private BindStatus previousStatus;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setIgnoreNestedPath(boolean ignoreNestedPath) {
        this.ignoreNestedPath = ignoreNestedPath;
    }

    public boolean isIgnoreNestedPath() {
        return this.ignoreNestedPath;
    }

    protected final int doStartTagInternal() throws Exception {
        String nestedPath;
        String resolvedPath = ExpressionEvaluationUtils.evaluateString((String)"path", (String)this.getPath(), (PageContext)this.pageContext);
        if (!this.isIgnoreNestedPath() && (nestedPath = (String)this.pageContext.getAttribute("nestedPath", 2)) != null) {
            resolvedPath = nestedPath + resolvedPath;
        }
        try {
            this.status = new BindStatus(this.getRequestContext(), resolvedPath, this.isHtmlEscape());
        }
        catch (IllegalStateException ex) {
            throw new JspTagException(ex.getMessage());
        }
        this.previousStatus = (BindStatus)this.pageContext.getAttribute(STATUS_VARIABLE_NAME);
        this.pageContext.setAttribute(STATUS_VARIABLE_NAME, (Object)this.status);
        return 1;
    }

    public int doEndTag() {
        if (this.previousStatus != null) {
            this.pageContext.setAttribute(STATUS_VARIABLE_NAME, (Object)this.previousStatus);
        } else {
            this.pageContext.removeAttribute(STATUS_VARIABLE_NAME);
        }
        return 6;
    }

    public final String getProperty() {
        return this.status.getExpression();
    }

    public final Errors getErrors() {
        return this.status.getErrors();
    }

    public final PropertyEditor getEditor() {
        return this.status.getEditor();
    }

    public void doFinally() {
        super.doFinally();
        this.status = null;
        this.previousStatus = null;
    }
}

