/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentRegistrar;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.config.AbstractSpecificationExecutor;
import org.springframework.context.config.SpecificationContext;
import org.springframework.web.servlet.config.MvcViewControllers;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MvcViewControllersExecutor
extends AbstractSpecificationExecutor<MvcViewControllers> {
    private static final String HANDLER_ADAPTER_BEAN_NAME = "org.springframework.web.servlet.config.viewControllerHandlerAdapter";
    private static final String HANDLER_MAPPING_BEAN_NAME = "org.springframework.web.servlet.config.viewControllerHandlerMapping";

    MvcViewControllersExecutor() {
    }

    protected void doExecute(MvcViewControllers spec, SpecificationContext specContext) {
        BeanDefinitionRegistry registry = specContext.getRegistry();
        ComponentRegistrar registrar = specContext.getRegistrar();
        Object source = spec.source();
        if (!registry.containsBeanDefinition(HANDLER_ADAPTER_BEAN_NAME)) {
            RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(SimpleControllerHandlerAdapter.class);
            handlerAdapterDef.setSource(source);
            handlerAdapterDef.setRole(2);
            registry.registerBeanDefinition(HANDLER_ADAPTER_BEAN_NAME, (BeanDefinition)handlerAdapterDef);
            registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, HANDLER_ADAPTER_BEAN_NAME));
        }
        BeanDefinition handlerMappingBeanDef = null;
        if (!registry.containsBeanDefinition(HANDLER_MAPPING_BEAN_NAME)) {
            RootBeanDefinition beanDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
            beanDef.setSource(source);
            beanDef.getPropertyValues().add("order", (Object)"1");
            beanDef.setRole(2);
            registry.registerBeanDefinition(HANDLER_MAPPING_BEAN_NAME, (BeanDefinition)beanDef);
            registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanDef, HANDLER_MAPPING_BEAN_NAME));
            handlerMappingBeanDef = beanDef;
        } else {
            handlerMappingBeanDef = registry.getBeanDefinition(HANDLER_MAPPING_BEAN_NAME);
        }
        for (Map.Entry<String, String> entry : spec.mappings().entrySet()) {
            RootBeanDefinition viewControllerDef = new RootBeanDefinition(ParameterizableViewController.class);
            viewControllerDef.setSource(source);
            if (entry.getValue() != null) {
                viewControllerDef.getPropertyValues().add("viewName", (Object)entry.getValue());
            }
            if (!handlerMappingBeanDef.getPropertyValues().contains("urlMap")) {
                handlerMappingBeanDef.getPropertyValues().add("urlMap", (Object)new ManagedMap());
            }
            Map urlMap = (Map)handlerMappingBeanDef.getPropertyValues().getPropertyValue("urlMap").getValue();
            urlMap.put(entry.getKey(), viewControllerDef);
        }
    }
}

