/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;

public class ResponseBodyEmitter {
    private final Long timeout;
    private volatile Handler handler;
    private final Map<Object, MediaType> initHandlerCache = new LinkedHashMap<Object, MediaType>(10);
    private volatile boolean complete;
    private Throwable failure;
    private Runnable timeoutCallback;
    private Runnable completionCallback;

    public ResponseBodyEmitter() {
        this.timeout = null;
    }

    public ResponseBodyEmitter(Long timeout) {
        this.timeout = timeout;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    protected void extendResponse(ServerHttpResponse outputMessage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(Handler handler) throws IOException {
        ResponseBodyEmitter responseBodyEmitter = this;
        synchronized (responseBodyEmitter) {
            this.handler = handler;
            for (Map.Entry<Object, MediaType> entry : this.initHandlerCache.entrySet()) {
                try {
                    this.sendInternal(entry.getKey(), entry.getValue());
                }
                catch (Throwable ex) {
                    return;
                }
            }
            if (this.complete) {
                if (this.failure != null) {
                    this.handler.completeWithError(this.failure);
                } else {
                    this.handler.complete();
                }
            }
            if (this.timeoutCallback != null) {
                this.handler.onTimeout(this.timeoutCallback);
            }
            if (this.completionCallback != null) {
                this.handler.onCompletion(this.completionCallback);
            }
        }
    }

    public void send(Object object) throws IOException {
        this.send(object, null);
    }

    public void send(Object object, MediaType mediaType) throws IOException {
        Assert.state((!this.complete ? 1 : 0) != 0, (String)"ResponseBodyEmitter is already set complete");
        this.sendInternal(object, mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInternal(Object object, MediaType mediaType) throws IOException {
        if (object == null) {
            return;
        }
        if (this.handler == null) {
            ResponseBodyEmitter responseBodyEmitter = this;
            synchronized (responseBodyEmitter) {
                if (this.handler == null) {
                    this.initHandlerCache.put(object, mediaType);
                    return;
                }
            }
        }
        try {
            this.handler.send(object, mediaType);
        }
        catch (IOException ex) {
            this.handler.completeWithError(ex);
            throw ex;
        }
        catch (Throwable ex) {
            this.handler.completeWithError(ex);
            throw new IllegalStateException("Failed to send " + object, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        ResponseBodyEmitter responseBodyEmitter = this;
        synchronized (responseBodyEmitter) {
            this.complete = true;
            if (this.handler != null) {
                this.handler.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeWithError(Throwable ex) {
        ResponseBodyEmitter responseBodyEmitter = this;
        synchronized (responseBodyEmitter) {
            this.complete = true;
            this.failure = ex;
            if (this.handler != null) {
                this.handler.completeWithError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeout(Runnable callback) {
        ResponseBodyEmitter responseBodyEmitter = this;
        synchronized (responseBodyEmitter) {
            this.timeoutCallback = callback;
            if (this.handler != null) {
                this.handler.onTimeout(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(Runnable callback) {
        ResponseBodyEmitter responseBodyEmitter = this;
        synchronized (responseBodyEmitter) {
            this.completionCallback = callback;
            if (this.handler != null) {
                this.handler.onCompletion(callback);
            }
        }
    }

    static interface Handler {
        public void send(Object var1, MediaType var2) throws IOException;

        public void complete();

        public void completeWithError(Throwable var1);

        public void onTimeout(Runnable var1);

        public void onCompletion(Runnable var1);
    }
}

