/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;

public abstract class ResourceTransformerSupport
implements ResourceTransformer {
    private ResourceUrlProvider resourceUrlProvider;

    public void setResourceUrlProvider(ResourceUrlProvider resourceUrlProvider) {
        this.resourceUrlProvider = resourceUrlProvider;
    }

    public ResourceUrlProvider getResourceUrlProvider() {
        return this.resourceUrlProvider;
    }

    protected String resolveUrlPath(String resourcePath, HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) {
        if (resourcePath.startsWith("/")) {
            ResourceUrlProvider urlProvider = this.findResourceUrlProvider(request);
            return urlProvider != null ? urlProvider.getForRequestUrl(request, resourcePath) : null;
        }
        return transformerChain.getResolverChain().resolveUrlPath(resourcePath, Collections.singletonList(resource));
    }

    protected String toAbsolutePath(String path, HttpServletRequest request) {
        String requestPath = this.getResourceUrlProvider().getUrlPathHelper().getRequestUri(request);
        String absolutePath = StringUtils.applyRelativePath((String)requestPath, (String)path);
        return StringUtils.cleanPath((String)absolutePath);
    }

    private ResourceUrlProvider findResourceUrlProvider(HttpServletRequest request) {
        if (this.resourceUrlProvider != null) {
            return this.resourceUrlProvider;
        }
        return (ResourceUrlProvider)request.getAttribute(ResourceUrlProviderExposingInterceptor.RESOURCE_URL_PROVIDER_ATTR);
    }
}

