/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.standard;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.WebSocketContainer;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.standard.StandardWebSocketHandlerAdapter;
import org.springframework.web.socket.adapter.standard.StandardWebSocketSession;
import org.springframework.web.socket.adapter.standard.WebSocketToStandardExtensionAdapter;
import org.springframework.web.socket.client.AbstractWebSocketClient;

public class StandardWebSocketClient
extends AbstractWebSocketClient {
    private final WebSocketContainer webSocketContainer;
    private AsyncListenableTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("WebSocketClient-");

    public StandardWebSocketClient() {
        this.webSocketContainer = ContainerProvider.getWebSocketContainer();
    }

    public StandardWebSocketClient(WebSocketContainer webSocketContainer) {
        Assert.notNull((Object)webSocketContainer, (String)"webSocketContainer must not be null");
        this.webSocketContainer = webSocketContainer;
    }

    public void setTaskExecutor(AsyncListenableTaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"TaskExecutor must not be null");
        this.taskExecutor = taskExecutor;
    }

    public AsyncListenableTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    protected ListenableFuture<WebSocketSession> doHandshakeInternal(WebSocketHandler webSocketHandler, HttpHeaders headers, final URI uri, List<String> protocols, List<WebSocketExtension> extensions, Map<String, Object> handshakeAttributes) {
        int port = this.getPort(uri);
        InetSocketAddress localAddress = new InetSocketAddress(this.getLocalHost(), port);
        InetSocketAddress remoteAddress = new InetSocketAddress(uri.getHost(), port);
        final StandardWebSocketSession session = new StandardWebSocketSession(headers, handshakeAttributes, localAddress, remoteAddress);
        final ClientEndpointConfig.Builder configBuidler = ClientEndpointConfig.Builder.create();
        configBuidler.configurator((ClientEndpointConfig.Configurator)new StandardWebSocketClientConfigurator(headers));
        configBuidler.preferredSubprotocols(protocols);
        configBuidler.extensions(StandardWebSocketClient.adaptExtensions(extensions));
        final StandardWebSocketHandlerAdapter endpoint = new StandardWebSocketHandlerAdapter(webSocketHandler, session);
        return this.taskExecutor.submitListenable((Callable)new Callable<WebSocketSession>(){

            @Override
            public WebSocketSession call() throws Exception {
                StandardWebSocketClient.this.webSocketContainer.connectToServer(endpoint, configBuidler.build(), uri);
                return session;
            }
        });
    }

    private static List<Extension> adaptExtensions(List<WebSocketExtension> extensions) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (WebSocketExtension e : extensions) {
            result.add(new WebSocketToStandardExtensionAdapter(e));
        }
        return result;
    }

    private InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress();
        }
    }

    private int getPort(URI uri) {
        if (uri.getPort() == -1) {
            String scheme = uri.getScheme().toLowerCase(Locale.ENGLISH);
            return "wss".equals(scheme) ? 443 : 80;
        }
        return uri.getPort();
    }

    private class StandardWebSocketClientConfigurator
    extends ClientEndpointConfig.Configurator {
        private final HttpHeaders headers;

        public StandardWebSocketClientConfigurator(HttpHeaders headers) {
            this.headers = headers;
        }

        public void beforeRequest(Map<String, List<String>> requestHeaders) {
            requestHeaders.putAll((Map<String, List<String>>)this.headers);
            if (StandardWebSocketClient.this.logger.isDebugEnabled()) {
                StandardWebSocketClient.this.logger.debug((Object)("Handshake request headers: " + requestHeaders));
            }
        }

        public void afterResponse(HandshakeResponse response) {
            if (StandardWebSocketClient.this.logger.isDebugEnabled()) {
                StandardWebSocketClient.this.logger.debug((Object)("Handshake response headers: " + response.getHeaders()));
            }
        }
    }
}

