/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ServerEndpointExporter
implements InitializingBean,
BeanPostProcessor,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(ServerEndpointExporter.class);
    private final List<Class<?>> annotatedEndpointClasses = new ArrayList();
    private final List<Class<?>> annotatedEndpointBeanTypes = new ArrayList();
    private ApplicationContext applicationContext;
    private ServerContainer serverContainer;

    public void setAnnotatedEndpointClasses(Class<?> ... annotatedEndpointClasses) {
        this.annotatedEndpointClasses.clear();
        this.annotatedEndpointClasses.addAll(Arrays.asList(annotatedEndpointClasses));
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.serverContainer = this.getServerContainer();
        Map beans = applicationContext.getBeansWithAnnotation(ServerEndpoint.class);
        for (String beanName : beans.keySet()) {
            Class beanType = applicationContext.getType(beanName);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Detected @ServerEndpoint bean '" + beanName + "', registering it as an endpoint by type"));
            }
            this.annotatedEndpointBeanTypes.add(beanType);
        }
    }

    protected ServerContainer getServerContainer() {
        Class servletContextClass;
        try {
            servletContextClass = ClassUtils.forName((String)"javax.servlet.ServletContext", (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Throwable ex) {
            return null;
        }
        try {
            Method getter = ReflectionUtils.findMethod(this.applicationContext.getClass(), (String)"getServletContext");
            Object servletContext = getter.invoke((Object)this.applicationContext, new Object[0]);
            Method attrMethod = ReflectionUtils.findMethod((Class)servletContextClass, (String)"getAttribute", (Class[])new Class[]{String.class});
            return (ServerContainer)attrMethod.invoke(servletContext, "javax.websocket.server.ServerContainer");
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to get javax.websocket.server.ServerContainer via ServletContext attribute", ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.serverContainer != null ? 1 : 0) != 0, (String)"javax.websocket.server.ServerContainer not available");
        ArrayList allClasses = new ArrayList(this.annotatedEndpointClasses);
        allClasses.addAll(this.annotatedEndpointBeanTypes);
        for (Class clazz : allClasses) {
            try {
                logger.info((Object)("Registering @ServerEndpoint type " + clazz));
                this.serverContainer.addEndpoint(clazz);
            }
            catch (DeploymentException e) {
                throw new IllegalStateException("Failed to register @ServerEndpoint type " + clazz, e);
            }
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ServerEndpointConfig) {
            ServerEndpointConfig sec = (ServerEndpointConfig)bean;
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Registering bean '" + beanName + "' as javax.websocket.Endpoint under path " + sec.getPath()));
                }
                this.getServerContainer().addEndpoint(sec);
            }
            catch (DeploymentException e) {
                throw new IllegalStateException("Failed to deploy Endpoint bean " + bean, e);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

